/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.XMLApplicationProfile;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.StandardResult;
import eu.dnetlib.validator2.validation.guideline.openaire.F3_01M_LIT;
import eu.dnetlib.validator2.validation.guideline.openaire.F3_01M_SPEC;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class F3_01M_SPEC_LIT
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(F3_01M_SPEC.class);

    public F3_01M_SPEC_LIT() {
        super("metadata clearly and explicitly include the identifier of the data it describes", "F3", "description", "https://w3id.org/fair/principles/latest/F3", "F", 10, RequirementLevel.MANDATORY);
    }

    @Override
    public Guideline.Result validate(String id, Document t) {
        F3_01M_LIT profile = new F3_01M_LIT();
        try {
            XMLApplicationProfile.ValidationResult res_F = profile.validate(id, t);
            Map<String, Guideline.Result> results = res_F.getResults();
            int MaxScoreF3_01M_LIT_SPEC = (int)res_F.getScore() == 50 ? (int)(2.0 * res_F.getScore() * (double)this.getWeight() / 100.0) : (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            ArrayList<String> warnings2 = new ArrayList<String>();
            ArrayList<String> errors2 = new ArrayList<String>();
            for (Map.Entry<String, Guideline.Result> entry : results.entrySet()) {
                String key = entry.getKey();
                String warningsStr = results.get(key).getWarnings().toString();
                String errorsStr = results.get(key).getErrors().toString();
                if (warningsStr.length() > 2) {
                    warnings2.add(warningsStr);
                }
                if (errorsStr.length() <= 2) continue;
                errors2.add(errorsStr);
            }
            Guideline.Result ress = F3_01M_SPEC_LIT.getResult(warnings2, errors2, MaxScoreF3_01M_LIT_SPEC);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static Guideline.Result getResult(ArrayList<String> warnings2, ArrayList<String> errors2, int score2) {
        return ResultUtils.getNewResult(warnings2, errors2, score2);
    }
}

