/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.XMLApplicationProfile;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.StandardResult;
import eu.dnetlib.validator2.validation.guideline.openaire.R1_01M;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class R1_01M_SPEC
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(R1_01M_SPEC.class);

    public R1_01M_SPEC() {
        super("meta(data) are richly described with a plurality of accurate and relevant attributes", "R1", "description", "https://w3id.org/fair/principles/latest/R1", "R", 12, RequirementLevel.MANDATORY);
    }

    @Override
    public Guideline.Result validate(String id, Document t) {
        R1_01M profile = new R1_01M();
        try {
            XMLApplicationProfile.ValidationResult res_F = profile.validate(id, t);
            Map<String, Guideline.Result> results = res_F.getResults();
            int MaxScoreR1_01M_SPEC = (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            ArrayList<String> warnings2 = new ArrayList<String>();
            ArrayList<String> errors2 = new ArrayList<String>();
            int score = 0;
            for (Map.Entry<String, Guideline.Result> entry : results.entrySet()) {
                String key = entry.getKey();
                String warningsStr = results.get(key).getWarnings().toString();
                String errorsStr = results.get(key).getErrors().toString();
                if (warningsStr.length() > 2) {
                    warnings2.add(warningsStr);
                }
                if (errorsStr.length() > 2) {
                    errors2.add(errorsStr);
                }
                if (!entry.getValue().toString().contains("SUCCESS")) continue;
                score += 3;
            }
            Guideline.Result ress = R1_01M_SPEC.getResult(warnings2, errors2, score);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static Guideline.Result getResult(ArrayList<String> warnings2, ArrayList<String> errors2, int score2) {
        return ResultUtils.getNewResult(warnings2, errors2, score2);
    }
}

