/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.StandardValidationResult;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.StandardResult;
import eu.dnetlib.validator2.validation.guideline.openaire.I2_01M_LIT;
import eu.dnetlib.validator2.validation.guideline.openaire.I2_01M_SPEC;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class I2_01M_SPEC_LIT
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(I2_01M_SPEC.class);

    public I2_01M_SPEC_LIT() {
        super("(meta)data use vocabularies that follow FAIR principles", "I2", "description", "https://w3id.org/fair/principles/latest/I2", "I2", 10, RequirementLevel.MANDATORY);
    }

    public StandardResult validate(String id, Document t) {
        I2_01M_LIT profile = new I2_01M_LIT();
        try {
            logger.debug("Metadata uses FAIR-compliant vocabularies");
            StandardValidationResult res_F = profile.validate(id, t);
            Map<String, StandardResult> results = res_F.getResults();
            int MaxScoreI2_01M_LIT_SPEC = (int)res_F.getScore() == 50 ? (int)(2.0 * res_F.getScore() * (double)this.getWeight() / 100.0) : (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            ArrayList<String> warnings2 = new ArrayList<String>();
            ArrayList<String> errors2 = new ArrayList<String>();
            for (Map.Entry<String, StandardResult> entry : results.entrySet()) {
                String key = entry.getKey();
                String warningsStr = results.get(key).getWarnings().toString();
                String errorsStr = results.get(key).getErrors().toString();
                if (warningsStr.length() > 2) {
                    warnings2.add(warningsStr);
                }
                if (errorsStr.length() <= 2) continue;
                errors2.add(errorsStr);
            }
            StandardResult ress = I2_01M_SPEC_LIT.getResult(warnings2, errors2, MaxScoreI2_01M_LIT_SPEC);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static StandardResult getResult(ArrayList<String> warnings2, ArrayList<String> errors2, int score2) {
        return ResultUtils.getNewResult(warnings2, errors2, score2);
    }
}

