/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine.builtins;

import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.RuleContext;
import eu.dnetlib.validator2.engine.RuleEvaluationException;
import eu.dnetlib.validator2.engine.builtins.AbstractRuleBuilder;
import eu.dnetlib.validator2.engine.builtins.StandardXMLContextWithNotConfusedFields;
import eu.dnetlib.validator2.engine.contexts.XMLContextWithNotConfusedFields;
import eu.dnetlib.validator2.engine.contexts.XPathExpressionProperty;
import java.util.HashSet;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XMLNotConfusedFieldsRule
implements Rule<Document> {
    private final XMLContextWithNotConfusedFields context;

    protected XMLNotConfusedFieldsRule(XMLContextWithNotConfusedFields context) {
        this.context = context;
    }

    @Override
    public RuleContext getContext() {
        return this.context;
    }

    @Override
    public boolean test(Document doc) throws RuleEvaluationException {
        XPathExpressionProperty xpathExprProp = this.context.getXPathExpressionProperty();
        HashSet allNodeValues = new HashSet();
        try {
            for (String xpath : this.context.getFieldsProperty().getXpaths()) {
                xpathExprProp.setValue(xpath);
                NodeList nodesReturned = xpathExprProp.evaluate(doc);
                boolean nodesReturnedAreUnique = this.context.getNodeListActionProperty().test(nodesReturned, v -> {
                    String val = v.trim().toLowerCase();
                    return allNodeValues.add(val);
                });
                if (nodesReturnedAreUnique) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            throw new RuleEvaluationException(t.getMessage(), t);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractRuleBuilder<XMLNotConfusedFieldsRule, XMLContextWithNotConfusedFields> {
        Builder() {
            super(new StandardXMLContextWithNotConfusedFields());
            this.initialize();
        }

        private void initialize() {
            ((XMLContextWithNotConfusedFields)this.context).getXPathExpressionProperty().setValue("notNull");
            ((XMLContextWithNotConfusedFields)this.context).getNodeListActionProperty().setValue("all");
        }

        public Builder setId(String id) {
            ((XMLContextWithNotConfusedFields)this.context).getIdProperty().setValue(id);
            return this;
        }

        public Builder setFields(String fields) {
            ((XMLContextWithNotConfusedFields)this.context).getFieldsProperty().setValue(fields);
            return this;
        }

        @Override
        public XMLNotConfusedFieldsRule build() {
            this.ensureContextIsValid();
            return new XMLNotConfusedFieldsRule((XMLContextWithNotConfusedFields)this.context);
        }

        @Override
        public XMLNotConfusedFieldsRule buildFrom(Map<String, String> map) {
            ((XMLContextWithNotConfusedFields)this.context).readFrom(map);
            this.ensureContextIsValid();
            return new XMLNotConfusedFieldsRule((XMLContextWithNotConfusedFields)this.context);
        }
    }
}

