/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.StandardValidationResult;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.F3_01M;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class F3_01M_SPEC
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(F3_01M_SPEC.class);

    public F3_01M_SPEC() {
        super("metadata clearly and explicitly include the identifier of the data it describes", "F3", "description", "https://w3id.org/fair/principles/latest/F3", "F", 10, RequirementLevel.MANDATORY);
    }

    public StandardResult validate(String id, Document t) {
        F3_01M profile = new F3_01M();
        try {
            StandardValidationResult res_F = profile.validate(id, t);
            Map results = res_F.getResults();
            int MaxScoreF3_01M_SPEC = (int)res_F.getScore() == 50 ? (int)(2.0 * res_F.getScore() * (double)this.getWeight() / 100.0) : (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            StandardResult ress = F3_01M_SPEC.getResult(results.entrySet(), MaxScoreF3_01M_SPEC);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static StandardResult getResult(Set<Map.Entry<String, StandardResult>> data, int score) {
        return ResultUtils.getNewResult(data, score);
    }
}

