/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline;

import eu.dnetlib.validator2.engine.Helper;
import eu.dnetlib.validator2.engine.Predicates;
import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.AttributeSpec;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementPosition;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.NodeSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Document;

public final class Builders {
    static final Predicate<String> ALLOW_ALL_VALUES = value -> true;

    @Deprecated
    public static ElementSpecBuilder forElement(String elementName) {
        return new ElementSpecBuilder(elementName);
    }

    public static ElementSpecBuilder forOptionalElement(String elementName) {
        return new ElementSpecBuilder(elementName).optional();
    }

    public static ElementSpecBuilder forOptionalRepeatableElement(String elementName) {
        return new ElementSpecBuilder(elementName).optionalRepeatable();
    }

    public static ElementSpecBuilder forRecommendedElement(String elementName) {
        return new ElementSpecBuilder(elementName).recommended();
    }

    public static ElementSpecBuilder forRecommendedRepeatableElement(String elementName) {
        return new ElementSpecBuilder(elementName).recommendedRepeatable();
    }

    public static ElementSpecBuilder forMandatoryElement(String elementName, Cardinality cardinality) {
        return new ElementSpecBuilder(elementName).mandatory(cardinality);
    }

    public static <T> ElementSpecBuilder forMandatoryIfApplicableElement(String elementName, Cardinality cardinality, Rule<Document> applicabilityRule) {
        return new ElementSpecBuilder(elementName).mandatoryIfApplicable(cardinality, applicabilityRule);
    }

    @Deprecated
    public static ElementSpecBuilder forElement(String elementName, RequirementLevel requirementLevel, Cardinality cardinality) {
        return Helper.buildElement(elementName, requirementLevel, cardinality);
    }

    @Deprecated
    public static ElementSpecBuilder forElement(String elementName, RequirementLevel requirementLevel, Cardinality cardinality, String ... allowedValues) {
        return Helper.buildElement(elementName, requirementLevel, cardinality).allowedValues(allowedValues);
    }

    @Deprecated
    public static ElementSpecBuilder forElement(String elementName, RequirementLevel requirementLevel, Cardinality cardinality, Predicate<String> allowedValuesPredicate) {
        return Helper.buildElement(elementName, requirementLevel, cardinality).allowedValues(allowedValuesPredicate);
    }

    private static Predicate<String> allowedValuesPredicateFor(String type, String ... allowedValues) {
        if (allowedValues == null || allowedValues.length == 0) {
            throw new IllegalArgumentException(type + " allowed values cannot be empty");
        }
        Predicates.SetOfCaseInsensitiveAllowedValues setOfAllowedValues = new Predicates.SetOfCaseInsensitiveAllowedValues(allowedValues);
        if (setOfAllowedValues.isEmpty()) {
            throw new IllegalArgumentException(type + " allowed values cannot be empty");
        }
        return setOfAllowedValues;
    }

    private static void validate(String type, String name, RequirementLevel requirementLevel, Predicate<String> allowedValuesPredicate, Rule<Document> applicabilityRule) {
        if (requirementLevel == null) {
            throw new IllegalStateException(type + ":" + name + " requirement level cannot be empty");
        }
        if (allowedValuesPredicate == null) {
            throw new IllegalStateException(type + ":" + name + " allowed values predicate cannot be empty");
        }
        Builders.validate(type, name, requirementLevel, applicabilityRule);
    }

    private static void validate(String type, String name, RequirementLevel requirementLevel, Cardinality cardinality, Predicate<String> allowedValuesPredicate, Rule<Document> applicabilityRule) {
        Builders.validate(type, name, requirementLevel, allowedValuesPredicate, applicabilityRule);
        if (cardinality == null) {
            throw new IllegalStateException(type + ":" + name + " cardinality cannot be empty");
        }
    }

    private static void validate(String type, String name, RequirementLevel requirementLevel, Rule<Document> applicabilityRule) {
        if (requirementLevel == RequirementLevel.MANDATORY_IF_APPLICABLE && applicabilityRule == null) {
            throw new IllegalStateException(type + ": " + name + " is invalid: required applicability rule is missing");
        }
        if (requirementLevel != RequirementLevel.MANDATORY_IF_APPLICABLE && applicabilityRule != null) {
            throw new IllegalStateException(type + ": " + name + " is invalid: an applicability rule is present");
        }
    }

    public static class ElementSpecBuilder {
        private final String elementName;
        private String[] parents;
        private RequirementLevel elementRequirementLevel;
        private Cardinality elementCardinality;
        private ElementPosition elementPosition;
        private String valuePrefix;
        private Predicate<String> allowedValuesPredicate = ALLOW_ALL_VALUES;
        private Set<AttributeSpec> attributeSpecs = new LinkedHashSet<AttributeSpec>();
        private Set<ElementSpecBuilder> subElementSpecs = new LinkedHashSet<ElementSpecBuilder>();
        private Rule<Document> applicabilityRule;

        private ElementSpecBuilder(String elementName) {
            this.elementName = elementName;
        }

        private ElementSpecBuilder with(RequirementLevel requirementLevel, Cardinality cardinality) {
            this.elementRequirementLevel = requirementLevel;
            this.elementCardinality = cardinality;
            return this;
        }

        public ElementSpecBuilder inContext(String ... parentElementNames) {
            this.parents = parentElementNames;
            return this;
        }

        private ElementSpecBuilder optional() {
            return this.with(RequirementLevel.OPTIONAL, Cardinality.ONE);
        }

        private ElementSpecBuilder optionalRepeatable() {
            return this.with(RequirementLevel.OPTIONAL, Cardinality.ONE_TO_N);
        }

        private ElementSpecBuilder recommended() {
            return this.with(RequirementLevel.RECOMMENDED, Cardinality.ONE);
        }

        private ElementSpecBuilder recommendedRepeatable() {
            return this.with(RequirementLevel.RECOMMENDED, Cardinality.ONE_TO_N);
        }

        private ElementSpecBuilder mandatory(Cardinality cardinality) {
            return this.with(RequirementLevel.MANDATORY, cardinality);
        }

        private ElementSpecBuilder mandatoryIfApplicable(Cardinality cardinality, Rule<Document> applicabilityRule) {
            this.applicabilityRule = applicabilityRule;
            return this.with(RequirementLevel.MANDATORY_IF_APPLICABLE, cardinality);
        }

        public ElementSpecBuilder allowedValues(String ... allowedValues) {
            this.allowedValuesPredicate = Builders.allowedValuesPredicateFor("Element", allowedValues);
            return this;
        }

        public ElementSpecBuilder allowedValues(Predicate<String> allowedValuesPredicate) {
            this.allowedValuesPredicate = allowedValuesPredicate;
            return this;
        }

        public ElementSpecBuilder atPosition(ElementPosition elementOccurrence) {
            this.elementPosition = elementOccurrence;
            return this;
        }

        public ElementSpecBuilder valueMustStartWith(String prefix) {
            String canonical = Helper.canonicalize(prefix);
            if (canonical.isEmpty()) {
                throw new IllegalArgumentException("Prefix cannot be empty");
            }
            this.valuePrefix = canonical;
            return this;
        }

        public ElementSpecBuilder withOptionalAttribute(String attributeName) {
            return this.withAttribute(attributeName, RequirementLevel.OPTIONAL, ALLOW_ALL_VALUES);
        }

        public ElementSpecBuilder withOptionalAttribute(String attributeName, String ... allowedValues) {
            return this.withAttribute(attributeName, RequirementLevel.OPTIONAL, allowedValues);
        }

        public ElementSpecBuilder withOptionalAttribute(String attributeName, Predicate<String> allowedValuesPredicate) {
            return this.withAttribute(attributeName, RequirementLevel.OPTIONAL, allowedValuesPredicate);
        }

        public ElementSpecBuilder withRecommendedAttribute(String attributeName) {
            return this.withAttribute(attributeName, RequirementLevel.RECOMMENDED, ALLOW_ALL_VALUES);
        }

        public ElementSpecBuilder withRecommendedAttribute(String attributeName, String ... allowedValues) {
            return this.withAttribute(attributeName, RequirementLevel.RECOMMENDED, allowedValues);
        }

        public ElementSpecBuilder withRecommendedAttribute(String attributeName, Predicate<String> allowedValuesPredicate) {
            return this.withAttribute(attributeName, RequirementLevel.RECOMMENDED, allowedValuesPredicate);
        }

        public ElementSpecBuilder withMandatoryAttribute(String attributeName) {
            return this.withAttribute(attributeName, RequirementLevel.MANDATORY, ALLOW_ALL_VALUES);
        }

        public ElementSpecBuilder withMandatoryAttribute(String attributeName, String ... allowedValues) {
            return this.withAttribute(attributeName, RequirementLevel.MANDATORY, allowedValues);
        }

        public ElementSpecBuilder withMandatoryAttribute(String attributeName, Predicate<String> allowedValuesPredicate) {
            return this.withAttribute(attributeName, RequirementLevel.MANDATORY, allowedValuesPredicate);
        }

        public ElementSpecBuilder withMandatoryIfApplicableAttribute(String attributeName, Rule<Document> applicabilityRule) {
            return this.withAttribute(attributeName, RequirementLevel.MANDATORY_IF_APPLICABLE, ALLOW_ALL_VALUES, applicabilityRule);
        }

        public ElementSpecBuilder withMandatoryIfApplicableAttribute(String attributeName, Rule<Document> applicabilityRule, String ... allowedValues) {
            return this.withAttribute(attributeName, RequirementLevel.MANDATORY_IF_APPLICABLE, Builders.allowedValuesPredicateFor("Attribute", allowedValues), applicabilityRule);
        }

        public ElementSpecBuilder withMandatoryIfApplicableAttribute(String attributeName, Rule<Document> applicabilityRule, Predicate<String> allowedValuesPredicate) {
            return this.withAttribute(attributeName, RequirementLevel.MANDATORY_IF_APPLICABLE, allowedValuesPredicate, applicabilityRule);
        }

        public ElementSpecBuilder withSubElement(ElementSpecBuilder subElementSpecBuilder) {
            this.subElementSpecs.add(subElementSpecBuilder);
            return this;
        }

        public ElementSpec build() {
            Set<String> setOfParents;
            String canonical = Helper.ensureNonEmpty(this.elementName, () -> new IllegalStateException("Element name cannot be empty"));
            Builders.validate("Element", this.elementName, this.elementRequirementLevel, this.elementCardinality, this.allowedValuesPredicate, this.applicabilityRule);
            Set<String> set = setOfParents = this.parents == null ? Collections.emptySet() : Stream.of(this.parents).filter(p -> !Helper.isEmpty(p)).collect(Collectors.toSet());
            if (this.elementPosition == null) {
                this.elementPosition = ElementPosition.ALL;
            }
            return new DefaultElementSpec(setOfParents, canonical, this.elementRequirementLevel, this.elementCardinality, this.allowedValuesPredicate, this.applicabilityRule, this.elementPosition, this.valuePrefix, this.attributeSpecs, this.subElementSpecs.stream().map(ElementSpecBuilder::build).collect(Collectors.toCollection(LinkedHashSet::new)));
        }

        private ElementSpecBuilder withAttribute(String attrName, RequirementLevel requirementLevel) {
            return this.withAttribute(attrName, requirementLevel, ALLOW_ALL_VALUES, null);
        }

        private ElementSpecBuilder withAttribute(String attrName, RequirementLevel requirementLevel, String ... allowedValues) {
            return this.withAttribute(attrName, requirementLevel, Builders.allowedValuesPredicateFor("Attribute", allowedValues), null);
        }

        private ElementSpecBuilder withAttribute(String attrName, RequirementLevel requirementLevel, Predicate<String> allowedValuesPredicate) {
            return this.withAttribute(attrName, requirementLevel, allowedValuesPredicate, null);
        }

        private ElementSpecBuilder withAttribute(String attrName, RequirementLevel requirementLevel, Predicate<String> allowedValuesPredicate, Rule<Document> applicabilityRule) {
            String canonical = Helper.ensureNonEmpty(attrName, () -> new IllegalStateException("Attribute name cannot be empty"));
            Builders.validate("Attribute", attrName, requirementLevel, allowedValuesPredicate, applicabilityRule);
            this.attributeSpecs.add(new DefaultAttributeSpec(canonical, requirementLevel, allowedValuesPredicate, applicabilityRule));
            return this;
        }

        public String toString() {
            return "ElementSpecBuilder{elementName='" + this.elementName + '\'' + ", parents=" + Arrays.toString(this.parents) + ", elementRequirementLevel=" + this.elementRequirementLevel + ", elementCardinality=" + (Object)((Object)this.elementCardinality) + ", elementPosition=" + (Object)((Object)this.elementPosition) + ", valuePrefix='" + this.valuePrefix + '\'' + ", allowedValuesPredicate=" + this.allowedValuesPredicate + ", attributeSpecs=" + this.attributeSpecs + ", subElementSpecs=" + this.subElementSpecs + ", applicabilityRule=" + this.applicabilityRule + '}';
        }
    }

    private static class DefaultElementSpec
    extends DefaultNodeSpec
    implements ElementSpec {
        private final Set<String> parents;
        private final Set<AttributeSpec> attributeSpecs;
        private final Set<ElementSpec> subElementSpecs;
        private final String valuePrefix;
        private final ElementPosition elementPosition;

        DefaultElementSpec(Set<String> parents, String name, RequirementLevel requirementLevel, Cardinality cardinality, Predicate<String> allowedValuesPredicate, Rule<Document> applicabilityRule, ElementPosition elementPosition, String valuePrefix, Set<AttributeSpec> attributeSpecs, Set<ElementSpec> subElementSpecs) {
            super(name, requirementLevel, cardinality, allowedValuesPredicate, applicabilityRule);
            this.parents = parents;
            this.elementPosition = elementPosition;
            this.valuePrefix = valuePrefix;
            this.attributeSpecs = attributeSpecs;
            this.subElementSpecs = subElementSpecs;
        }

        @Override
        public Set<String> parents() {
            return this.parents;
        }

        @Override
        public Set<ElementSpec> subElementSpecs() {
            return this.subElementSpecs;
        }

        @Override
        public Set<AttributeSpec> attributeSpecs() {
            return this.attributeSpecs;
        }

        @Override
        public String valuePrefix() {
            return this.valuePrefix;
        }

        @Override
        public ElementPosition position() {
            return this.elementPosition;
        }

        @Override
        public String toString() {
            return "DefaultElementSpec{parents=" + this.parents + ", attributeSpecs=" + this.attributeSpecs + ", subElementSpecs=" + this.subElementSpecs + ", valuePrefix='" + this.valuePrefix + '\'' + ", elementPosition=" + (Object)((Object)this.elementPosition) + '}';
        }
    }

    private static class DefaultAttributeSpec
    extends DefaultNodeSpec
    implements AttributeSpec {
        DefaultAttributeSpec(String name, RequirementLevel requirementLevel, Predicate<String> allowedValuesPredicate, Rule<Document> applicabilityRule) {
            super(name, requirementLevel, Cardinality.ONE, allowedValuesPredicate, applicabilityRule);
        }
    }

    private static class DefaultNodeSpec
    implements NodeSpec {
        private final String name;
        private final RequirementLevel requirementLevel;
        private final Cardinality cardinality;
        private final Predicate<String> allowedValuesPredicate;
        private final Rule<Document> applicabilityRule;

        DefaultNodeSpec(String name, RequirementLevel requirementLevel, Cardinality cardinality, Predicate<String> allowedValuesPredicate, Rule<Document> applicabilityRule) {
            this.name = name;
            this.requirementLevel = requirementLevel;
            this.cardinality = cardinality;
            this.allowedValuesPredicate = allowedValuesPredicate;
            this.applicabilityRule = applicabilityRule;
        }

        @Override
        public String nodeName() {
            return this.name;
        }

        @Override
        public RequirementLevel requirementLevel() {
            return this.requirementLevel;
        }

        @Override
        public Cardinality cardinality() {
            return this.cardinality;
        }

        @Override
        public Predicate<String> allowedValuesPredicate() {
            return this.allowedValuesPredicate;
        }

        @Override
        public Rule<Document> applicabilityRule() {
            return this.applicabilityRule;
        }

        public String toString() {
            return "DefaultNodeSpec{name='" + this.name + '\'' + ", requirementLevel=" + this.requirementLevel + ", cardinality=" + (Object)((Object)this.cardinality) + ", allowedValuesPredicate=" + this.allowedValuesPredicate + ", applicabilityRule=" + this.applicabilityRule + '}';
        }
    }
}

