/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.task;

public final class RuleEvaluationResult {
    private static final byte SUCCESS = 0;
    private static final byte FAILURE = 2;
    private static final byte ERROR = 4;
    private static final byte INTERRUPTED = 8;
    private final byte result;
    private final String errorMessage;

    RuleEvaluationResult(byte result, String errorMessage) {
        this.result = result;
        this.errorMessage = errorMessage;
    }

    public boolean succeeded() {
        return this.result == 0;
    }

    public boolean failed() {
        return this.result == 2;
    }

    public boolean errored() {
        return this.result == 4;
    }

    public boolean interrupted() {
        return this.result == 8;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    static RuleEvaluationResult forSuccess() {
        return new RuleEvaluationResult(0, null);
    }

    static RuleEvaluationResult forFailure(String message) {
        return new RuleEvaluationResult(2, message);
    }

    static RuleEvaluationResult forError(String errorMessage) {
        return new RuleEvaluationResult(4, errorMessage);
    }

    static RuleEvaluationResult forInterrupted() {
        return new RuleEvaluationResult(8, null);
    }
}

