/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine;

import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.RuleDiagnostics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reporter<T, R extends Rule<T>> {
    private static final Logger logger = LoggerFactory.getLogger(Reporter.class);
    private final RuleDiagnostics<T, R> diagnostics;

    public Reporter(RuleDiagnostics<T, R> diagnostics) {
        this.diagnostics = diagnostics;
    }

    public void reportSuccessFor(R rule, T t) {
        try {
            this.diagnostics.success(rule, t);
        }
        catch (Throwable throwable) {
            logger.error("Failed to report success of applying " + rule + " to value: " + t, throwable);
        }
    }

    public void reportFailureFor(R rule, T t, String message) {
        try {
            this.diagnostics.failure(rule, t, message);
        }
        catch (Throwable throwable) {
            logger.error("Failed to report failure of applying " + rule + " to value: " + t, throwable);
        }
    }

    public void reportErrorFor(R rule, T t, Throwable throwable) {
        try {
            this.diagnostics.error(rule, t, throwable);
        }
        catch (Throwable throwable1) {
            logger.error("Failed to report error of applying " + rule + " to value: " + t, throwable);
        }
    }

    public String toString() {
        return "Reporter{diagnostics=" + this.diagnostics + '}';
    }
}

