/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine.builtins;

import eu.dnetlib.validator2.engine.Helper;
import eu.dnetlib.validator2.engine.RuleValidationResult;
import eu.dnetlib.validator2.engine.TestResultPredicate;
import eu.dnetlib.validator2.engine.builtins.AbstractRuleBuilder;
import eu.dnetlib.validator2.engine.builtins.StandardXMLContext;
import eu.dnetlib.validator2.engine.builtins.XMLRule;
import eu.dnetlib.validator2.engine.contexts.XMLContext;
import java.util.Map;
import org.w3c.dom.NodeList;

public class XMLFieldExistsRule
extends XMLRule<XMLContext> {
    protected XMLFieldExistsRule(XMLContext context) {
        super(context, nodes -> {
            TestResultPredicate<String> fieldExistsPredicate = v -> {
                if (!Helper.isEmpty(v)) {
                    return RuleValidationResult.success();
                }
                return RuleValidationResult.failure("field value is empty");
            };
            return context.getNodeListActionProperty().test((NodeList)nodes, fieldExistsPredicate);
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractRuleBuilder<XMLFieldExistsRule, XMLContext> {
        private Builder() {
            super(new StandardXMLContext());
        }

        public Builder setId(String id) throws IllegalArgumentException {
            ((XMLContext)this.context).getIdProperty().setValue(id);
            return this;
        }

        public Builder setXPathExpression(String xpath) throws IllegalArgumentException {
            ((XMLContext)this.context).getXPathExpressionProperty().setValue(xpath);
            return this;
        }

        public Builder setNodeListAction(String nodeListAction) throws RuntimeException {
            ((XMLContext)this.context).getNodeListActionProperty().setValue(nodeListAction);
            return this;
        }

        @Override
        public XMLFieldExistsRule build() {
            this.ensureContextIsValid();
            return new XMLFieldExistsRule((XMLContext)this.context);
        }

        @Override
        public XMLFieldExistsRule buildFrom(Map<String, String> map) {
            ((XMLContext)this.context).readFrom(map);
            this.ensureContextIsValid();
            return new XMLFieldExistsRule((XMLContext)this.context);
        }
    }
}

