/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine.builtins;

import eu.dnetlib.validator2.engine.RuleValidationResult;
import eu.dnetlib.validator2.engine.TestResultPredicate;
import eu.dnetlib.validator2.engine.builtins.AbstractRuleBuilder;
import eu.dnetlib.validator2.engine.builtins.StandardCrisClassXMLContextWithVocabulary;
import eu.dnetlib.validator2.engine.builtins.XMLRule;
import eu.dnetlib.validator2.engine.contexts.TermsProperty;
import eu.dnetlib.validator2.engine.contexts.XMLCrisClassSchemeContextWithVocabulary;
import java.util.Map;
import org.w3c.dom.NodeList;

public class XMLCrisClassVocabularyRule
extends XMLRule<XMLCrisClassSchemeContextWithVocabulary> {
    protected XMLCrisClassVocabularyRule(XMLCrisClassSchemeContextWithVocabulary context) {
        super(context, nodes -> {
            String schemeId = context.getCrisClassSchemeIdProperty().getValue();
            TermsProperty terms = context.getTermsProperty();
            String termsType = terms.getValue().toLowerCase();
            TestResultPredicate<String> termPredicate = value -> {
                boolean exists = terms.termExists((String)value).isSuccess();
                if (termsType.equals("blacklist")) {
                    if (exists) {
                        return RuleValidationResult.failure("value '" + value + "' found in blacklist for scheme '" + schemeId + "'");
                    }
                    return RuleValidationResult.success();
                }
                if (exists) {
                    return RuleValidationResult.success();
                }
                return RuleValidationResult.failure("value '" + value + "' not found in whitelist for scheme '" + schemeId + "'");
            };
            return context.getNodeListActionProperty().test((NodeList)nodes, termPredicate);
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractRuleBuilder<XMLCrisClassVocabularyRule, XMLCrisClassSchemeContextWithVocabulary> {
        Builder() {
            super(new StandardCrisClassXMLContextWithVocabulary());
            this.initialize();
        }

        private void initialize() {
            ((XMLCrisClassSchemeContextWithVocabulary)this.context).getTermsTypeProperty().setValue("notNull");
        }

        public Builder setId(String id) {
            ((XMLCrisClassSchemeContextWithVocabulary)this.context).getIdProperty().setValue(id);
            return this;
        }

        public Builder setXPathExpression(String xpath) {
            ((XMLCrisClassSchemeContextWithVocabulary)this.context).getXPathExpressionProperty().setValue(xpath);
            return this;
        }

        public Builder setNodeListAction(String nodeListAction) throws RuntimeException {
            ((XMLCrisClassSchemeContextWithVocabulary)this.context).getNodeListActionProperty().setValue(nodeListAction);
            return this;
        }

        public Builder setVocabularyTerms(String terms) {
            ((XMLCrisClassSchemeContextWithVocabulary)this.context).getTermsProperty().setValue(terms);
            return this;
        }

        public Builder setCrisClassSchemeId(String id) {
            ((XMLCrisClassSchemeContextWithVocabulary)this.context).getCrisClassSchemeIdProperty().setValue(id);
            return this;
        }

        @Override
        public XMLCrisClassVocabularyRule build() {
            this.ensureContextIsValid();
            return new XMLCrisClassVocabularyRule((XMLCrisClassSchemeContextWithVocabulary)this.context);
        }

        @Override
        public XMLCrisClassVocabularyRule buildFrom(Map<String, String> map) {
            ((XMLCrisClassSchemeContextWithVocabulary)this.context).readFrom(map);
            this.ensureContextIsValid();
            return new XMLCrisClassVocabularyRule((XMLCrisClassSchemeContextWithVocabulary)this.context);
        }
    }
}

