/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine.builtins;

import eu.dnetlib.validator2.engine.RuleValidationResult;
import eu.dnetlib.validator2.engine.builtins.AbstractRuleBuilder;
import eu.dnetlib.validator2.engine.builtins.StandardXMLContextWithCardinality;
import eu.dnetlib.validator2.engine.builtins.XMLRule;
import eu.dnetlib.validator2.engine.contexts.XMLContextWithCardinality;
import java.util.Map;

public class XMLCardinalityRule
extends XMLRule<XMLContextWithCardinality> {
    protected XMLCardinalityRule(XMLContextWithCardinality context) {
        super(context, nodes -> {
            RuleValidationResult result = context.cardinalityPredicate().test(nodes.getLength());
            if (result.isSuccess()) {
                return result;
            }
            String suggestion = "Check the number of occurrences of the element targeted by the XPath expression: " + context.getXPathExpressionProperty().getValue();
            return RuleValidationResult.failure(result.getMessage(), suggestion);
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractRuleBuilder<XMLCardinalityRule, XMLContextWithCardinality> {
        private Builder() {
            super(new StandardXMLContextWithCardinality());
            ((XMLContextWithCardinality)this.context).getNodeListActionProperty().setValue("length");
        }

        public Builder setId(String id) throws IllegalArgumentException {
            ((XMLContextWithCardinality)this.context).getIdProperty().setValue(id);
            return this;
        }

        public Builder setXPathExpression(String xpath) throws IllegalArgumentException {
            ((XMLContextWithCardinality)this.context).getXPathExpressionProperty().setValue(xpath);
            return this;
        }

        public Builder setRange(String greaterThan, String lessThan) throws IllegalArgumentException {
            ((XMLContextWithCardinality)this.context).getLowerBoundProperty().setValue(greaterThan);
            ((XMLContextWithCardinality)this.context).getUpperBoundProperty().setValue(lessThan);
            return this;
        }

        public Builder setRange(long greaterThan, long lessThan) {
            ((XMLContextWithCardinality)this.context).getLowerBoundProperty().setLongValue(greaterThan);
            ((XMLContextWithCardinality)this.context).getUpperBoundProperty().setLongValue(lessThan);
            return this;
        }

        public Builder setIsInclusive(boolean isInclusive) {
            ((XMLContextWithCardinality)this.context).getIsInclusiveProperty().setTrue(isInclusive);
            return this;
        }

        @Override
        public XMLCardinalityRule build() throws IllegalStateException {
            this.ensureContextIsValid();
            return new XMLCardinalityRule((XMLContextWithCardinality)this.context);
        }

        @Override
        public XMLCardinalityRule buildFrom(Map<String, String> map) throws IllegalStateException {
            ((XMLContextWithCardinality)this.context).readFrom(map);
            this.ensureContextIsValid();
            return new XMLCardinalityRule((XMLContextWithCardinality)this.context);
        }
    }
}

