/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline;

import eu.dnetlib.validator2.engine.Helper;
import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.RuleContext;
import eu.dnetlib.validator2.engine.RuleEvaluationException;
import eu.dnetlib.validator2.engine.RuleValidationResult;
import eu.dnetlib.validator2.engine.TestResultPredicate;
import eu.dnetlib.validator2.engine.builtins.SimpleContext;
import eu.dnetlib.validator2.engine.builtins.StandardXMLContext;
import eu.dnetlib.validator2.engine.builtins.XMLRule;
import eu.dnetlib.validator2.engine.builtins.XPathExpressionHelper;
import eu.dnetlib.validator2.engine.contexts.XMLContext;
import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.AttributeSpec;
import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.CompilationResult;
import eu.dnetlib.validator2.validation.guideline.ElementPosition;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.GuidelineEvaluation;
import eu.dnetlib.validator2.validation.guideline.SyntheticRule;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ElementSpecCompiler {
    private static final Logger logger = LoggerFactory.getLogger(ElementSpecCompiler.class);
    private static final String[] EMPTY = new String[0];
    private final List<ElementSpec> specs = new ArrayList<ElementSpec>();
    private final CompilationResult compilationResult = new CompilationResult();

    ElementSpecCompiler() {
    }

    CompilationResult compile(ElementSpec elementSpec, Supplier<GuidelineEvaluation> runtimeInfo) {
        ElementStruct rootElement = new ElementStruct(elementSpec, runtimeInfo);
        this.generateRulesForElement(rootElement);
        return this.compilationResult;
    }

    private void generateRulesForElement(ElementStruct currentElement) {
        this.specs.add(currentElement.spec);
        if (currentElement.parent == null) {
            currentElement.createRootElemRule(this.compilationResult);
        } else {
            currentElement.createSubElemRule(this.compilationResult);
        }
        for (AttributeSpec attrSpec : currentElement.spec.attributeSpecs()) {
            currentElement.createAttrRule(this.compilationResult, attrSpec);
        }
        for (ElementSpec subElementSpec : currentElement.spec.subElementSpecs()) {
            this.generateRulesForElement(new ElementStruct(currentElement.elementsArray, subElementSpec, currentElement));
        }
    }

    private static String[] copyAndAppend(String[] elements, String newElem) {
        int len = elements.length;
        String[] newElements = new String[len + 1];
        System.arraycopy(elements, 0, newElements, 0, len);
        newElements[len] = newElem;
        return newElements;
    }

    private static String xpathForNodeName(String name) {
        return "name()='" + name + "'";
    }

    private static String xpathForNodeName(String name, String valuePrefix) {
        CharSequence[] components = new String[]{ElementSpecCompiler.xpathForNodeName(name)};
        if (valuePrefix != null) {
            components = ElementSpecCompiler.copyAndAppend((String[])components, "starts-with(normalize-space(text()), '" + valuePrefix + "')");
        }
        return String.join((CharSequence)" and ", components);
    }

    private static String xpathForAttributeName(String name) {
        return "@" + name;
    }

    private static String xpathWithText(String xpath, boolean withText) {
        return withText ? xpath + "/text()" : xpath;
    }

    static String nodeRuleIdFor(String nodeType, String nodeName, RequirementLevel requirementLevel, ElementPosition position, String valuePrefix, TestResultPredicate<String> allowedValuesPredicate, Cardinality cardinality) {
        StringBuilder builder = new StringBuilder("The ").append(requirementLevel.name().toLowerCase()).append(" rule: '").append(nodeName).append("' ").append(nodeType.toLowerCase());
        if (position != ElementPosition.ALL) {
            builder.append(" at ").append(position.name().toLowerCase()).append(" position");
        }
        if (valuePrefix != null) {
            builder.append(" has values that start with '").append(valuePrefix).append("',");
        }
        if (!ElementSpecCompiler.allowsAllValues(allowedValuesPredicate)) {
            builder.append(" contains allowed values only,");
        }
        builder.append(" has cardinality ").append(cardinality.asText());
        return builder.toString();
    }

    static String cardinalityRuleIdFor(String nodeName, RequirementLevel requirementLevel, Cardinality cardinality, String valuePrefix) {
        String id = requirementLevel.name() + " rule: " + nodeName + " has cardinality " + cardinality.asText();
        if (Helper.isEmpty(valuePrefix)) {
            return id;
        }
        return id + " for values starting with '" + valuePrefix + "'";
    }

    static final String mergeNodeNames(String ... names) {
        return String.join((CharSequence)"/", names);
    }

    private static boolean allowsAllValues(TestResultPredicate<String> allowedValuesPredicate) {
        return allowedValuesPredicate == null || allowedValuesPredicate == Builders.ALLOW_ALL_VALUES;
    }

    private static SyntheticRule<Document> createActualRootElementRule(Supplier<GuidelineEvaluation> runtimeInfo, String id, String xpath, String xpathForValue, Cardinality cardinality, TestResultPredicate<String> allowedValuesPredicate, Rule<Document> applicabilityRule) {
        XMLContext ctx = ElementSpecCompiler.createCustomXMLContext(id, xpath);
        TestResultPredicate<NodeList> lengthChecker = elements -> Helper.createCardinalityPredicate(cardinality.getLowerBound(), cardinality.getUpperBound(), true).test(elements.getLength());
        if (ElementSpecCompiler.allowsAllValues(allowedValuesPredicate)) {
            return new RootElemRule(ctx, lengthChecker, applicabilityRule, runtimeInfo);
        }
        TestResultPredicate<NodeList> lengthCheckerOnAllowedElements = elements -> {
            NodeList filtered = ElementSpecCompiler.filterNodes(elements, xpathForValue, allowedValuesPredicate);
            return lengthChecker.test(filtered);
        };
        return new RootElemRule(ctx, lengthCheckerOnAllowedElements, applicabilityRule, runtimeInfo);
    }

    private static SyntheticRule<Document> createActualAttributeSpecRule(Supplier<GuidelineEvaluation> runtimeInfo, SyntheticRule<Document> parentRule, String id, String attrName, TestResultPredicate<String> allowedValuesPredicate, Rule<Document> applicabilityRule) {
        SimpleContext ctx = new SimpleContext(id);
        if (ElementSpecCompiler.allowsAllValues(allowedValuesPredicate)) {
            return new NodeSpecRule<SimpleContext>(ctx, parentRule, elements -> {
                NodeList attrs = ElementSpecCompiler.attributesOf(elements, attrName, s -> !Helper.isEmpty(s));
                if (elements != null && attrs.getLength() == elements.getLength()) {
                    return RuleValidationResult.success();
                }
                return RuleValidationResult.failure("attribute '" + attrName + "' not found on all parent elements", "Ensure the attribute '" + attrName + "' is present on all parent elements.");
            }, applicabilityRule, runtimeInfo);
        }
        TestResultPredicate<NodeList> allowedAttrsLengthEqualsElemLength = elements -> {
            NodeList attrs = ElementSpecCompiler.attributesOf(elements, attrName, s -> allowedValuesPredicate.test((String)s).isSuccess());
            if (elements != null && elements.getLength() == attrs.getLength()) {
                return RuleValidationResult.success();
            }
            return RuleValidationResult.failure("attribute '" + attrName + "' with allowed values not found on all parent elements", "Ensure the attribute '" + attrName + "' on all parent elements has a value from the allowed set.");
        };
        return new NodeSpecRule<SimpleContext>(ctx, parentRule, allowedAttrsLengthEqualsElemLength, applicabilityRule, runtimeInfo);
    }

    private static SyntheticRule<Document> createActualSubElementRule(Supplier<GuidelineEvaluation> runtimeInfo, SyntheticRule<Document> parentRule, String id, String xpath, String xpathForValue, Cardinality cardinality, TestResultPredicate<String> allowedValuesPredicate, Rule<Document> applicabilityRule) {
        XMLContext ctx = ElementSpecCompiler.createCustomXMLContext(id, xpath);
        TestResultPredicate<NodeList> lengthChecker = elements -> {
            TestResultPredicate<Integer> lengthPredicate = ElementSpecCompiler.createLengthPredicateForSubElements(runtimeInfo, parentRule, cardinality);
            return lengthPredicate.test(elements.getLength());
        };
        if (ElementSpecCompiler.allowsAllValues(allowedValuesPredicate)) {
            return new SubElemRule(ctx, parentRule, lengthChecker, applicabilityRule, runtimeInfo);
        }
        TestResultPredicate<NodeList> lengthCheckerOnAllowedElements = elements -> {
            NodeList filtered = ElementSpecCompiler.filterNodes(elements, xpathForValue, allowedValuesPredicate);
            return lengthChecker.test(filtered);
        };
        return new SubElemRule(ctx, parentRule, lengthCheckerOnAllowedElements, applicabilityRule, runtimeInfo);
    }

    private static TestResultPredicate<Integer> createLengthPredicateForSubElements(Supplier<GuidelineEvaluation> runtimeInfo, SyntheticRule<Document> parentRule, Cardinality cardinality) {
        long max;
        long min;
        GuidelineEvaluation evaluation = runtimeInfo.get();
        NodeList parents = evaluation.getNodesOf(parentRule.getContext().getIdProperty().getValue());
        if (parents == null) {
            return count -> RuleValidationResult.failure("parent element not found, cannot check sub-element cardinality", "Ensure the parent element exists before checking its sub-elements.");
        }
        int parentsLength = parents.getLength();
        if (cardinality == Cardinality.ONE) {
            min = parentsLength;
            max = parentsLength;
        } else if (cardinality == Cardinality.ONE_TO_N) {
            min = parentsLength;
            max = Long.MAX_VALUE;
        } else if (cardinality == Cardinality.TWO) {
            min = parentsLength * 2;
            max = parentsLength * 2;
        } else if (cardinality == Cardinality.FOUR_TO_N) {
            min = parentsLength * 4;
            max = Long.MAX_VALUE;
        } else {
            throw new RuleEvaluationException(" Unsupported cardinality " + (Object)((Object)cardinality), null);
        }
        return Helper.createCardinalityPredicate(min, max, true);
    }

    private static NodeList attributesOf(NodeList elements, String attrName, Predicate<String> allowedValues) {
        return Helper.nodesThatMatchThePredicate(elements, node -> Helper.getAttributeValue(node, attrName), allowedValues);
    }

    private static XMLContext createCustomXMLContext(String id, String xpath) {
        StandardXMLContext context = new StandardXMLContext();
        context.getIdProperty().setValue(id);
        context.getXPathExpressionProperty().setValue(xpath);
        context.getNodeListActionProperty().setValue("custom");
        return context;
    }

    private static NodeList filterNodes(NodeList nodes, String xpathToReadValues, TestResultPredicate<String> allowedValuesPredicate) {
        logger.debug("Filtering nodes with {}", (Object)xpathToReadValues);
        return Helper.nodesThatMatchThePredicate(nodes, new NodeValueReader(xpathToReadValues), s -> allowedValuesPredicate.test((String)s).isSuccess());
    }

    private static TestResultPredicate<Document> isApplicable(SyntheticRule<Document> rule, GuidelineEvaluation guidelineEvaluation) {
        return doc -> {
            Rule<Document> applicabilityRule = rule.applicabilityRule();
            if (applicabilityRule == null) {
                logger.debug("Null applicability rule of {}", (Object)rule.getContext().getIdProperty().getValue());
                return RuleValidationResult.success();
            }
            String thisId = rule.getContext().getIdProperty().getValue();
            RuleValidationResult applicabilityResult = applicabilityRule.test((Document)doc);
            if (applicabilityResult.isSuccess()) {
                logger.debug("Success of applicability rule of {}", (Object)rule.getContext().getIdProperty().getValue());
                guidelineEvaluation.setRequirementLevelOf(thisId, RequirementLevel.MANDATORY);
                return RuleValidationResult.success();
            }
            logger.debug("Failure of applicability rule of {}", (Object)rule.getContext().getIdProperty().getValue());
            guidelineEvaluation.setRequirementLevelOf(thisId, RequirementLevel.NOT_APPLICABLE);
            return RuleValidationResult.failure(applicabilityResult.getMessage(), applicabilityResult.getSuggestion());
        };
    }

    private static class NodeSpecRule<C extends RuleContext>
    implements SyntheticRule<Document> {
        private final C context;
        private final TestResultPredicate<NodeList> nodeListPredicate;
        private final Rule<Document> applicabilityRule;
        private final SyntheticRule<Document> parentRule;
        private final Supplier<GuidelineEvaluation> runtimeInfo;
        private NodeList testedNodes;

        NodeSpecRule(C context, SyntheticRule<Document> parentRule, TestResultPredicate<NodeList> nodeListPredicate, Rule<Document> applicabilityRule, Supplier<GuidelineEvaluation> runtimeInfo) {
            this.context = context;
            this.parentRule = parentRule;
            this.nodeListPredicate = nodeListPredicate;
            this.applicabilityRule = applicabilityRule;
            this.runtimeInfo = runtimeInfo;
        }

        @Override
        public C getContext() {
            return this.context;
        }

        @Override
        public SyntheticRule<Document> parentRule() {
            return this.parentRule;
        }

        @Override
        public Rule<Document> applicabilityRule() {
            return this.applicabilityRule;
        }

        @Override
        public RuleValidationResult test(Document doc) throws RuleEvaluationException {
            GuidelineEvaluation guidelineEvaluation = this.runtimeInfo.get();
            String thisId = this.getContext().getIdProperty().getValue();
            String parentRuleId = this.parentRule.getContext().getIdProperty().getValue();
            if (guidelineEvaluation.getRequirementLevelOf(parentRuleId) == RequirementLevel.NOT_APPLICABLE) {
                guidelineEvaluation.setRequirementLevelOf(thisId, RequirementLevel.NOT_APPLICABLE);
                return RuleValidationResult.success();
            }
            if (ElementSpecCompiler.isApplicable(this, guidelineEvaluation).test(doc).isSuccess()) {
                NodeList nodes;
                this.testedNodes = nodes = guidelineEvaluation.getNodesOf(parentRuleId);
                logger.debug("Acquired node list of parent rule '{}' = {}", (Object)parentRuleId, nodes == null ? "null" : Integer.valueOf(nodes.getLength()));
                RuleValidationResult result = this.nodeListPredicate.test(nodes);
                if (result.isSuccess()) {
                    logger.debug("Setting node list of this rule {}", (Object)thisId);
                    guidelineEvaluation.setNodesOf(thisId, nodes);
                }
                return result;
            }
            return RuleValidationResult.success();
        }

        @Override
        public NodeList getTestedNodes() {
            return this.testedNodes;
        }

        public String toString() {
            return "NodeSpecRule{id='" + this.getContext().getIdProperty().getValue() + '\'' + ", parentRule=" + this.parentRule + '}';
        }
    }

    private static class ElemRule
    extends XMLRule<XMLContext>
    implements SyntheticRule<Document> {
        protected final SyntheticRule<Document> parentRule;
        protected final Supplier<GuidelineEvaluation> runtimeInfo;
        protected final Rule<Document> applicabilityRule;
        protected NodeList testedNodes;

        ElemRule(XMLContext context, SyntheticRule<Document> parentRule, TestResultPredicate<NodeList> nodeListPredicate, Rule<Document> applicabilityRule, Supplier<GuidelineEvaluation> runtimeInfo) {
            super(context, nodeListPredicate);
            this.parentRule = parentRule;
            this.applicabilityRule = applicabilityRule;
            this.runtimeInfo = runtimeInfo;
        }

        @Override
        public SyntheticRule<Document> parentRule() {
            return this.parentRule;
        }

        @Override
        public Rule<Document> applicabilityRule() {
            return this.applicabilityRule;
        }

        @Override
        public NodeList getTestedNodes() {
            return this.testedNodes;
        }

        @Override
        public String toString() {
            return "ElemRule{parentRule=" + this.parentRule + ", runtimeInfo=" + this.runtimeInfo + ", applicabilityRule=" + this.applicabilityRule + ", testedNodes=" + this.testedNodes + '}';
        }
    }

    private static class SubElemRule
    extends ElemRule {
        SubElemRule(XMLContext context, SyntheticRule<Document> parentRule, TestResultPredicate<NodeList> nodeListPredicate, Rule<Document> applicabilityRule, Supplier<GuidelineEvaluation> runtimeInfo) {
            super(context, parentRule, nodeListPredicate, applicabilityRule, runtimeInfo);
        }

        @Override
        public RuleValidationResult test(Document doc) throws RuleEvaluationException {
            GuidelineEvaluation guidelineEvaluation = (GuidelineEvaluation)this.runtimeInfo.get();
            String thisId = this.getContext().getIdProperty().getValue();
            String parentRuleId = this.parentRule.getContext().getIdProperty().getValue();
            if (guidelineEvaluation.getRequirementLevelOf(parentRuleId) == RequirementLevel.NOT_APPLICABLE) {
                guidelineEvaluation.setRequirementLevelOf(thisId, RequirementLevel.NOT_APPLICABLE);
                return RuleValidationResult.success();
            }
            if (ElementSpecCompiler.isApplicable(this, guidelineEvaluation).test(doc).isSuccess()) {
                try {
                    NodeList nodes;
                    logger.debug("Applying {}", (Object)thisId);
                    this.testedNodes = nodes = this.getContext().getXPathExpressionProperty().evaluate(doc);
                    RuleValidationResult result = this.predicate.test(nodes);
                    if (result.isSuccess()) {
                        logger.debug("Setting node list of this rule {}", (Object)thisId);
                        guidelineEvaluation.setNodesOf(thisId, nodes);
                    }
                    return result;
                }
                catch (Throwable t) {
                    throw new RuleEvaluationException(t.getMessage(), t);
                }
            }
            return RuleValidationResult.success();
        }

        @Override
        public String toString() {
            return "SubElemRule{testedNodes=" + this.testedNodes + ", applicabilityRule=" + this.applicabilityRule + ", runtimeInfo=" + this.runtimeInfo + ", parentRule=" + this.parentRule + '}';
        }
    }

    private static class RootElemRule
    extends ElemRule {
        RootElemRule(XMLContext context, TestResultPredicate<NodeList> nodeListPredicate, Rule<Document> applicabilityRule, Supplier<GuidelineEvaluation> runtimeInfo) {
            super(context, null, nodeListPredicate, applicabilityRule, runtimeInfo);
        }

        @Override
        public RuleValidationResult test(Document doc) throws RuleEvaluationException {
            GuidelineEvaluation guidelineEvaluation = (GuidelineEvaluation)this.runtimeInfo.get();
            RuleContext context = this.getContext();
            String thisId = context.getIdProperty().getValue();
            if (ElementSpecCompiler.isApplicable(this, guidelineEvaluation).test(doc).isSuccess()) {
                try {
                    NodeList nodes;
                    logger.debug("Applying {}", (Object)thisId);
                    this.testedNodes = nodes = context.getXPathExpressionProperty().evaluate(doc);
                    RuleValidationResult result = this.predicate.test(nodes);
                    if (result.isSuccess()) {
                        logger.debug("Setting node list of this rule {}", (Object)thisId);
                        guidelineEvaluation.setNodesOf(thisId, nodes);
                    }
                    return result;
                }
                catch (Throwable t) {
                    throw new RuleEvaluationException(t.getMessage(), t);
                }
            }
            return RuleValidationResult.success();
        }

        @Override
        public String toString() {
            return "RootElemRule{testedNodes=" + this.testedNodes + ", applicabilityRule=" + this.applicabilityRule + ", runtimeInfo=" + this.runtimeInfo + ", parentRule=" + this.parentRule + '}';
        }
    }

    private static class ElementStruct {
        private static final Logger logger = LoggerFactory.getLogger(ElementStruct.class);
        Supplier<GuidelineEvaluation> runtimeInfo;
        final ElementSpec spec;
        final String[] parentElementNames;
        final ElementStruct parent;
        final String[] elementsArray;
        final String elementsId;
        SyntheticRule<Document> rule;

        ElementStruct(String[] parentElementNames, ElementSpec spec, ElementStruct parent) {
            this.runtimeInfo = parent.runtimeInfo;
            this.parentElementNames = parentElementNames;
            this.spec = spec;
            this.parent = parent;
            this.elementsArray = ElementSpecCompiler.copyAndAppend(parentElementNames, spec.nodeName());
            this.elementsId = ElementSpecCompiler.mergeNodeNames(this.elementsArray);
        }

        ElementStruct(ElementSpec spec, Supplier<GuidelineEvaluation> runtimeInfo) {
            this.runtimeInfo = runtimeInfo;
            this.parentElementNames = EMPTY;
            this.spec = spec;
            this.parent = null;
            this.elementsArray = ElementSpecCompiler.copyAndAppend(this.parentElementNames, spec.nodeName());
            this.elementsId = ElementSpecCompiler.mergeNodeNames(this.elementsArray);
        }

        private String xpath(boolean withText) {
            String xpath;
            String xpathForThis = ElementSpecCompiler.xpathForNodeName(this.spec.nodeName(), this.spec.valuePrefix());
            if (this.parent == null) {
                List pathComponents = this.spec.parents().stream().map(s -> "*[" + ElementSpecCompiler.xpathForNodeName(s) + "]").collect(Collectors.toList());
                pathComponents.add("*[" + xpathForThis + "]");
                xpath = "//" + String.join((CharSequence)"/", pathComponents);
            } else {
                xpath = this.parent.xpath(false) + "/*[" + xpathForThis + "]";
            }
            if (this.spec.position().xpath != null) {
                xpath = "(" + xpath + ")[" + this.spec.position().xpath + "]";
            }
            if (logger.isTraceEnabled()) {
                logger.trace(xpath);
            }
            return ElementSpecCompiler.xpathWithText(xpath, withText);
        }

        private void createRootElemRule(CompilationResult compilationResult) {
            String id = ElementSpecCompiler.nodeRuleIdFor("Element", this.elementsId, this.spec.requirementLevel(), this.spec.position(), this.spec.valuePrefix(), this.spec.allowedValuesPredicate(), this.spec.cardinality());
            SyntheticRule rule = ElementSpecCompiler.createActualRootElementRule(this.runtimeInfo, id, this.xpath(false), "text()", this.spec.cardinality(), this.spec.allowedValuesPredicate(), this.spec.applicabilityRule());
            compilationResult.ruleIdToRequirementLevel.put(id, this.spec.requirementLevel());
            compilationResult.rootNodeRule = rule;
            this.rule = rule;
        }

        private void createAttrRule(CompilationResult compilationResult, AttributeSpec attrSpec) {
            String attrRuleIdComponent = ElementSpecCompiler.mergeNodeNames(this.elementsId, attrSpec.nodeName());
            String attrRuleId = ElementSpecCompiler.nodeRuleIdFor("Attribute", attrRuleIdComponent, attrSpec.requirementLevel(), ElementPosition.ALL, this.spec.valuePrefix(), attrSpec.allowedValuesPredicate(), this.spec.cardinality());
            SyntheticRule rule = ElementSpecCompiler.createActualAttributeSpecRule(this.runtimeInfo, this.rule, attrRuleId, attrSpec.nodeName(), attrSpec.allowedValuesPredicate(), attrSpec.applicabilityRule());
            compilationResult.ruleIdToRequirementLevel.put(attrRuleId, attrSpec.requirementLevel());
            compilationResult.nodeRules.add(rule);
            this.rule = rule;
        }

        private void createSubElemRule(CompilationResult compilationResult) {
            String id = ElementSpecCompiler.nodeRuleIdFor("Element", this.elementsId, this.spec.requirementLevel(), this.spec.position(), this.spec.valuePrefix(), this.spec.allowedValuesPredicate(), this.spec.cardinality());
            SyntheticRule rule = ElementSpecCompiler.createActualSubElementRule(this.runtimeInfo, this.parent.rule, id, this.xpath(false), "text()", this.spec.cardinality(), this.spec.allowedValuesPredicate(), this.spec.applicabilityRule());
            compilationResult.ruleIdToRequirementLevel.put(id, this.spec.requirementLevel());
            compilationResult.nodeRules.add(rule);
            this.rule = rule;
        }
    }

    private static class NodeValueReader
    implements Function<Node, String> {
        private final String nodeExpr;

        NodeValueReader(String nodeExpr) {
            this.nodeExpr = nodeExpr;
        }

        @Override
        public String apply(Node parent) {
            logger.debug("Reading node value {} from parent {}", (Object)this.nodeExpr, (Object)parent);
            Node node = XPathExpressionHelper.node(this.nodeExpr, parent);
            return node == null ? null : node.getNodeValue();
        }
    }
}

