/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.utils;

import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.Status;
import eu.dnetlib.validator2.result_models.ValidationProblem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResultUtils.class);

    public static StandardResult getNewResult(Set<Map.Entry<String, StandardResult>> data, int score2) {
        boolean shouldAssignScoreInLoop;
        boolean bl = shouldAssignScoreInLoop = score2 == -1;
        if (shouldAssignScoreInLoop) {
            score2 = 0;
        }
        ArrayList warnings2 = new ArrayList();
        ArrayList errors2 = new ArrayList();
        for (Map.Entry<String, StandardResult> entry : data) {
            String key = entry.getKey();
            StandardResult standardResult = entry.getValue();
            List warnings = standardResult.getWarnings();
            List errors = standardResult.getErrors();
            if (!warnings.isEmpty()) {
                warnings2.addAll(warnings);
            }
            if (!errors.isEmpty()) {
                errors2.addAll(errors);
            }
            if (shouldAssignScoreInLoop && standardResult.toString().contains("SUCCESS")) {
                score2 += 3;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace(String.valueOf(standardResult.getWarnings().getClass()));
            logger.trace(String.valueOf(warnings2.getClass()));
        }
        StandardResult result = new StandardResult(){
            private int score;
            private Status status;
            private List<ValidationProblem> warnings;
            private List<ValidationProblem> errors;
            private String internalError;

            public int getScore() {
                return this.score;
            }

            public void setScore(int score) {
                this.score = score;
            }

            public Status getStatus() {
                return this.status;
            }

            public void setStatus(Status status) {
                this.status = status;
            }

            public List<ValidationProblem> getWarnings() {
                return this.warnings;
            }

            public void setWarnings(List<ValidationProblem> warnings) {
                this.warnings = warnings;
            }

            public List<ValidationProblem> getErrors() {
                return this.errors;
            }

            public void setErrors(List<ValidationProblem> errors) {
                this.errors = errors;
            }

            public String getInternalError() {
                return this.internalError;
            }

            public void setInternalError(String internalError) {
                this.internalError = internalError;
            }
        };
        result.setScore(score2);
        result.setStatus(Status.valueOf((String)(score2 > 0 ? "SUCCESS" : "FAILURE")));
        result.setWarnings(warnings2);
        result.setErrors(errors2);
        return result;
    }
}

