/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine;

import eu.dnetlib.validator2.engine.RuleValidationResult;
import java.util.Objects;

@FunctionalInterface
public interface TestResultPredicate<T> {
    public RuleValidationResult test(T var1);

    default public TestResultPredicate<T> or(TestResultPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> {
            RuleValidationResult result = this.test(t);
            if (result.isSuccess()) {
                return result;
            }
            return other.test(t);
        };
    }

    default public TestResultPredicate<T> and(TestResultPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> {
            RuleValidationResult result = this.test(t);
            if (!result.isSuccess()) {
                return result;
            }
            return other.test(t);
        };
    }

    default public TestResultPredicate<T> negate() {
        return t -> {
            RuleValidationResult result = this.test(t);
            if (result.isSuccess()) {
                return RuleValidationResult.failure("predicate was not expected to succeed", "The value should not pass this validation check.");
            }
            return RuleValidationResult.success();
        };
    }
}

