/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine.builtins;

import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.RuleEvaluationException;
import eu.dnetlib.validator2.engine.RuleValidationResult;
import eu.dnetlib.validator2.engine.TestResultPredicate;
import eu.dnetlib.validator2.engine.contexts.XMLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XMLRule<C extends XMLContext>
implements Rule<Document> {
    private static final Logger logger = LoggerFactory.getLogger(XMLRule.class);
    private final C context;
    public final TestResultPredicate<NodeList> predicate;

    public XMLRule(C context, TestResultPredicate<NodeList> predicate) {
        this.context = context;
        this.predicate = predicate;
    }

    @Override
    public C getContext() {
        return this.context;
    }

    @Override
    public RuleValidationResult test(Document doc) throws RuleEvaluationException {
        try {
            logger.debug("Applying {}", (Object)this.context.getIdProperty().getValue());
            NodeList nodes = this.context.getXPathExpressionProperty().evaluate(doc);
            return this.predicate.test(nodes);
        }
        catch (Throwable t) {
            throw new RuleEvaluationException(t.getMessage(), t);
        }
    }

    public String toString() {
        return "XMLRule{context=" + this.context + ", predicate=" + this.predicate + '}';
    }
}

