/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.utils.RegexValuePredicate;
import eu.dnetlib.validator2.validation.utils.SupportedRegExs;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public final class F2_01M_LIT_v3
extends AbstractOpenAireProfile {
    private static final ElementSpec F2_01M_LIT_v3_SPEC_1 = Builders.forMandatoryElement("dc:creator", Cardinality.ONE_TO_N).build();
    private static final ElementSpec F2_01M_LIT_v3_SPEC_2 = Builders.forMandatoryElement("dc:title", Cardinality.ONE_TO_N).build();
    private static final ElementSpec F2_01M_LIT_v3_SPEC_3 = Builders.forMandatoryElement("dc:publisher", Cardinality.ONE_TO_N).build();
    private static final ElementSpec F2_01M_LIT_v3_SPEC_4 = Builders.forMandatoryElement("dc:date", Cardinality.ONE).allowedValues(new RegexValuePredicate(SupportedRegExs.COMPILED_PUBLICATION_DATE_REG_EX)).build();
    private static final ElementSpec F2_01M_LIT_v3_SPEC_5 = Builders.forMandatoryElement("dc:description", Cardinality.ONE_TO_N).build();
    private static final ElementSpec F2_01M_LIT_v3_SPEC_6 = Builders.forMandatoryElement("dc:subject", Cardinality.ONE_TO_N).build();
    private static final ElementSpec F2_01M_LIT_v3_SPEC_7 = Builders.forMandatoryElement("dc:relation", Cardinality.ONE).allowedValues(new RegexValuePredicate(SupportedRegExs.COMPILED_PROJECT_IDENTIFIER_REGEX)).build();
    private static final ElementSpec F2_01M_LIT_v3_SPEC_8 = Builders.forRecommendedRepeatableElement("dc:contributor").build();
    public static SyntheticGuideline F2_01M_LIT_v3_1 = SyntheticGuideline.of("Creator", 2, F2_01M_LIT_v3_SPEC_1);
    public static SyntheticGuideline F2_01M_LIT_v3_2 = SyntheticGuideline.of("Title", 2, F2_01M_LIT_v3_SPEC_2);
    public static SyntheticGuideline F2_01M_LIT_v3_3 = SyntheticGuideline.of("Publisher", 2, F2_01M_LIT_v3_SPEC_3);
    public static SyntheticGuideline F2_01M_LIT_v3_4 = SyntheticGuideline.of("Date", 2, F2_01M_LIT_v3_SPEC_4);
    public static SyntheticGuideline F2_01M_LIT_v3_5 = SyntheticGuideline.of("Summary (Description with descriptionType)", 2, F2_01M_LIT_v3_SPEC_5);
    public static SyntheticGuideline F2_01M_LIT_v3_6 = SyntheticGuideline.of("Keywords (Subjects)", 2, F2_01M_LIT_v3_SPEC_6);
    public static SyntheticGuideline F2_01M_LIT_v3_7 = SyntheticGuideline.of("Project Identifier", 2, F2_01M_LIT_v3_SPEC_7);
    public static SyntheticGuideline F2_01M_LIT_v3_8 = SyntheticGuideline.of("Contributor", 2, F2_01M_LIT_v3_SPEC_8);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(F2_01M_LIT_v3_1, F2_01M_LIT_v3_2, F2_01M_LIT_v3_3, F2_01M_LIT_v3_4, F2_01M_LIT_v3_5, F2_01M_LIT_v3_6, F2_01M_LIT_v3_7, F2_01M_LIT_v3_8));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public F2_01M_LIT_v3() {
        super("Rich metadata is provided to allow discovery");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

