/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.guideline.openaire.F2_01M_SPEC_LIT_v3;
import eu.dnetlib.validator2.validation.guideline.openaire.F3_01M_SPEC_LIT_v3;
import eu.dnetlib.validator2.validation.guideline.openaire.F4M_SPEC_LIT_v3;
import eu.dnetlib.validator2.validation.guideline.openaire.I1M_SPEC_LIT_v3;
import eu.dnetlib.validator2.validation.guideline.openaire.R1_2_01M_SPEC_LIT_v3;
import eu.dnetlib.validator2.validation.guideline.openaire.R1_3_01M_SPEC_LIT_v3;
import eu.dnetlib.validator2.validation.utils.RegexValuePredicate;
import eu.dnetlib.validator2.validation.utils.SupportedRegExs;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Document;

public final class FAIR_Literature_GuidelinesV3Profile
extends AbstractOpenAireProfile {
    private static final String[] publicationTypes = new String[]{"info:eu-repo/semantics/article", "info:eu-repo/semantics/bachelorThesis", "info:eu-repo/semantics/masterThesis", "info:eu-repo/semantics/doctoralThesis", "info:eu-repo/semantics/book", "info:eu-repo/semantics/bookPart", "info:eu-repo/semantics/review", "info:eu-repo/semantics/conferenceObject", "info:eu-repo/semantics/lecture", "info:eu-repo/semantics/workingPaper", "info:eu-repo/semantics/preprint", "info:eu-repo/semantics/report", "info:eu-repo/semantics/annotation", "info:eu-repo/semantics/contributionToPeriodical", "info:eu-repo/semantics/patent", "info:eu-repo/semantics/other"};
    private static final String[] publicationVersions = new String[]{"info:eu-repo/semantics/draft", "info:eu-repo/semantics/submittedVersion", "info:eu-repo/semantics/acceptedVersion", "info:eu-repo/semantics/publishedVersion", "info:eu-repo/semantics/updateVersion"};
    private static final String[] publicationTypesAndVersions = (String[])Stream.concat(Arrays.stream(publicationTypes), Arrays.stream(publicationVersions)).toArray(String[]::new);
    private static final String[] audiences = new String[]{"Administrators", "Community Groups", "Counsellors", "Federal Funds Recipients and Applicants", "Librarians", "News Media", "Other", "Parents and Families", "Policymakers", "Researchers", "School Support Staff", "Student Financial Aid Providers", "Students", "Teachers"};
    private static final ElementSpec F1_01D_SPEC = Builders.forMandatoryElement("dc:identifier", Cardinality.ONE_TO_N).build();
    private static final ElementSpec I3_01M_SPEC_1 = Builders.forMandatoryElement("dc:relation", Cardinality.ONE_TO_N).build();
    private static final ElementSpec LICENSE_CONDITION_SPEC = Builders.forMandatoryElement("dc:rights", Cardinality.ONE_TO_N).allowedValues(new RegexValuePredicate(SupportedRegExs.COMPILED_LICENSE_CONDITION_REG_EX)).build();
    public static SyntheticGuideline F1_01D = SyntheticGuideline.of("(meta)data are assigned a globally unique and persistent identifier", "F1", "description", "https://w3id.org/fair/principles/latest/F1", "F", 1, RequirementLevel.MANDATORY, F1_01D_SPEC);
    public static SyntheticGuideline A1_01M = SyntheticGuideline.of("(meta)data are retrievable by their identifier using a standardized communications protocol", "A1", "description", "https://w3id.org/fair/principles/latest/A1", "A", 1, RequirementLevel.MANDATORY, F1_01D_SPEC);
    public static SyntheticGuideline A1_01_1M = SyntheticGuideline.of("the protocol is open, free, and universally implementable", "A1.1", "description", "https://w3id.org/fair/principles/latest/A1.1", "A", 1, RequirementLevel.MANDATORY, F1_01D_SPEC);
    public static SyntheticGuideline I3_01M_1 = SyntheticGuideline.of("(meta)data include qualified references to other (meta)data", "I3", "description", "https://w3id.org/fair/principles/latest/I3", "I", 1, RequirementLevel.MANDATORY, I3_01M_SPEC_1);
    public static SyntheticGuideline R1_1_01M = SyntheticGuideline.of("(meta)data are released with a clear and accessible data usage license", "R1.1", "description", "https://w3id.org/fair/principles/latest/R1.1", "R", 1, RequirementLevel.MANDATORY, LICENSE_CONDITION_SPEC);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(F1_01D, new F2_01M_SPEC_LIT_v3(), new F3_01M_SPEC_LIT_v3(), new F4M_SPEC_LIT_v3(), A1_01M, A1_01_1M, new I1M_SPEC_LIT_v3(), I3_01M_1, R1_1_01M, new R1_2_01M_SPEC_LIT_v3(), new R1_3_01M_SPEC_LIT_v3()));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public FAIR_Literature_GuidelinesV3Profile() {
        super("OpenAIRE FAIR Guidelines for Literature Repositories Profile v3");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

