/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementPosition;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.utils.MediaTypesValuePredicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public final class R1_01M_LIT_v3
extends AbstractOpenAireProfile {
    private static final String[] publicationTypes = new String[]{"info:eu-repo/semantics/article", "info:eu-repo/semantics/bachelorThesis", "info:eu-repo/semantics/masterThesis", "info:eu-repo/semantics/doctoralThesis", "info:eu-repo/semantics/book", "info:eu-repo/semantics/bookPart", "info:eu-repo/semantics/review", "info:eu-repo/semantics/conferenceObject", "info:eu-repo/semantics/lecture", "info:eu-repo/semantics/workingPaper", "info:eu-repo/semantics/preprint", "info:eu-repo/semantics/report", "info:eu-repo/semantics/annotation", "info:eu-repo/semantics/contributionToPeriodical", "info:eu-repo/semantics/patent", "info:eu-repo/semantics/other"};
    private static final String[] publicationVersions = new String[]{"info:eu-repo/semantics/draft", "info:eu-repo/semantics/submittedVersion", "info:eu-repo/semantics/acceptedVersion", "info:eu-repo/semantics/publishedVersion", "info:eu-repo/semantics/updateVersion"};
    private static final ElementSpec RESOURCE_TYPE_SPEC = Builders.forMandatoryElement("dc:type", Cardinality.ONE).atPosition(ElementPosition.FIRST).allowedValues(publicationTypes).build();
    private static final ElementSpec RESOURCE_VERSION_SPEC = Builders.forMandatoryElement("dc:type", Cardinality.ONE).allowedValues(publicationVersions).build();
    private static final ElementSpec FORMAT_SPEC = Builders.forMandatoryElement("dc:format", Cardinality.ONE_TO_N).allowedValues(new MediaTypesValuePredicate()).build();
    private static final ElementSpec DESCRIPTION_SPEC = Builders.forMandatoryElement("dc:description", Cardinality.ONE_TO_N).build();
    public static SyntheticGuideline R1_01M_LIT_1 = SyntheticGuideline.of("ResourceType", 4, RESOURCE_TYPE_SPEC);
    public static SyntheticGuideline R1_01M_LIT_2 = SyntheticGuideline.of("Format", 2, RESOURCE_VERSION_SPEC);
    public static SyntheticGuideline R1_01M_LIT_3 = SyntheticGuideline.of("Description", 2, FORMAT_SPEC);
    public static SyntheticGuideline R1_01M_LIT_4 = SyntheticGuideline.of("Description", 2, DESCRIPTION_SPEC);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(R1_01M_LIT_1, R1_01M_LIT_2, R1_01M_LIT_3, R1_01M_LIT_4));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public R1_01M_LIT_v3() {
        super("Plurality of accurate and relevant attributes are provided to allow reuse");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

