/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.common.author;

import eu.openaire.common.author.AuthorMatch;
import eu.openaire.common.author.AuthorMatchers;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class AuthorMatcherStep<BA, EA> {
    private final BiFunction<BA, EA, Optional<AuthorMatch<BA, EA>>> matchingFunc;
    private final Predicate<List<AuthorMatch<BA, EA>>> exclusionPredicate;
    private final String name;

    private AuthorMatcherStep(BiFunction<BA, EA, Optional<AuthorMatch<BA, EA>>> matchingFunc, Predicate<List<AuthorMatch<BA, EA>>> exclusionPredicate, String name) {
        this.matchingFunc = matchingFunc;
        this.exclusionPredicate = exclusionPredicate;
        this.name = name;
    }

    public static <BA, EA> Builder<BA, EA> stringIgnoreCaseMatcher(Function<BA, String> ex1, Function<EA, String> ex2) {
        return new Builder<Object, Object>().matchingFunc((ua, ca) -> {
            String base = (String)ex1.apply(ua);
            String enriching = (String)ex2.apply(ca);
            if (base == null || enriching == null) {
                return Optional.empty();
            }
            if (base.toLowerCase(Locale.ROOT).equals(enriching.toLowerCase(Locale.ROOT))) {
                return Optional.of(new AuthorMatch<Object, Object>(ua, ca, "", 1.0));
            }
            return Optional.empty();
        });
    }

    public static <BA, EA> Builder<BA, EA> abbreviationsMatcher(Function<BA, String> ex1, Function<EA, String> ex2) {
        return new Builder().name("abbreviations").matchingFunc((ua, ca) -> {
            String base = (String)ex1.apply(ua);
            String enriching = (String)ex2.apply(ca);
            return AuthorMatchers.matchOrderedTokenAndAbbreviations(base, enriching).map(confidence -> new AuthorMatch<Object, Object>(ua, ca, "", (double)confidence));
        });
    }

    public BiFunction<BA, EA, Optional<AuthorMatch<BA, EA>>> getMatchingFunc() {
        return this.matchingFunc;
    }

    public Predicate<List<AuthorMatch<BA, EA>>> getExclusionPredicate() {
        return this.exclusionPredicate;
    }

    public String getName() {
        return this.name;
    }

    public static class Builder<BA, EA> {
        private BiFunction<BA, EA, Optional<AuthorMatch<BA, EA>>> matchingFunc;
        private Predicate<List<AuthorMatch<BA, EA>>> exclusionPredicate;
        private String name;

        public Builder<BA, EA> matchingFunc(BiFunction<BA, EA, Optional<AuthorMatch<BA, EA>>> matchingFunc) {
            this.matchingFunc = matchingFunc;
            return this;
        }

        public Builder<BA, EA> exclusionPredicate(Predicate<List<AuthorMatch<BA, EA>>> exclusionPredicate) {
            this.exclusionPredicate = exclusionPredicate;
            return this;
        }

        public Builder<BA, EA> name(String name) {
            this.name = name;
            return this;
        }

        public AuthorMatcherStep<BA, EA> build() {
            BiFunction matchingF = this.matchingFunc;
            String stepName = this.name;
            return new AuthorMatcherStep((ua, ca) -> {
                AuthorMatch res = ((Optional)matchingF.apply(ua, ca)).orElse(null);
                if (res != null) {
                    return Optional.of(res.withStepName(stepName));
                }
                return Optional.empty();
            }, this.exclusionPredicate, stepName);
        }
    }
}

