/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.common.author;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class OrderedTokenAndAbbreviationsMatcher {
    public static final Pattern SPLIT_REGEX = Pattern.compile("[\\s\\p{Punct}\\p{Pd}]+");
    public static int NUM_TOKEN_MAX_DIFF = 2;

    private static List<String> tokenize(String s) {
        return Stream.of(SPLIT_REGEX.split(StringUtils.stripAccents((String)s).toLowerCase(Locale.ROOT))).filter(x -> !x.isEmpty()).sorted().collect(Collectors.toList());
    }

    public static Optional<Double> compare(String a1, String a2) {
        String a1_curr_token;
        if (a1 == null || a2 == null) {
            return Optional.empty();
        }
        List<String> a1_tokens = OrderedTokenAndAbbreviationsMatcher.tokenize(a1);
        List<String> a2_tokens = OrderedTokenAndAbbreviationsMatcher.tokenize(a2);
        int a1_num_tokens = a1_tokens.size();
        int a2_num_tokens = a2_tokens.size();
        if (a1_num_tokens < 2 || a2_num_tokens < 2) {
            return Optional.empty();
        }
        if (Math.abs(a1_num_tokens - a2_num_tokens) > NUM_TOKEN_MAX_DIFF) {
            return Optional.empty();
        }
        int a1_tokens_idx = 0;
        int a2_tokens_idx = 0;
        int shortMatches = 0;
        int longMatches = 0;
        int crossMatches = 0;
        while (a1_tokens_idx < a1_tokens.size() && a2_tokens_idx < a2_tokens.size()) {
            a1_curr_token = a1_tokens.get(a1_tokens_idx);
            if (a1_curr_token.length() < 2) {
                ++a1_tokens_idx;
                continue;
            }
            String a2_curr_token = a2_tokens.get(a2_tokens_idx);
            if (a2_curr_token.length() < 2) {
                ++a2_tokens_idx;
                continue;
            }
            int diff = a1_curr_token.compareTo(a2_curr_token);
            if (diff > 0) {
                ++a2_tokens_idx;
                continue;
            }
            if (diff < 0) {
                ++a1_tokens_idx;
                continue;
            }
            ++longMatches;
            a1_tokens.remove(a1_tokens_idx);
            a2_tokens.remove(a2_tokens_idx);
        }
        a1_tokens_idx = 0;
        a2_tokens_idx = 0;
        while (a1_tokens_idx < a1_tokens.size() && a2_tokens_idx < a2_tokens.size()) {
            String a2_curr_token;
            char a2_curr_token_initial;
            a1_curr_token = a1_tokens.get(a1_tokens_idx);
            char a1_curr_token_initial = a1_curr_token.charAt(0);
            if (a1_curr_token_initial < (a2_curr_token_initial = (a2_curr_token = a2_tokens.get(a2_tokens_idx)).charAt(0))) {
                ++a1_tokens_idx;
                continue;
            }
            if (a1_curr_token_initial > a2_curr_token_initial) {
                ++a2_tokens_idx;
                continue;
            }
            if (a1_curr_token.equals(a2_curr_token)) {
                if (a1_curr_token.length() > 1) {
                    ++longMatches;
                } else {
                    ++shortMatches;
                }
                ++a1_tokens_idx;
                ++a2_tokens_idx;
                continue;
            }
            if (a1_curr_token.length() == 1 || a2_curr_token.length() == 1) {
                ++crossMatches;
                ++a1_tokens_idx;
                ++a2_tokens_idx;
                continue;
            }
            if (a1_curr_token.compareTo(a2_curr_token) < 0) {
                ++a1_tokens_idx;
                continue;
            }
            ++a2_tokens_idx;
        }
        if (longMatches > 0 && shortMatches + longMatches + crossMatches == Math.min(a1_num_tokens, a2_num_tokens)) {
            double matchScore = ((double)longMatches * 1.0 + (double)shortMatches * 0.75 + (double)crossMatches * 0.5) / (double)Math.max(a1_num_tokens, a2_num_tokens);
            return Optional.of(matchScore * 0.95);
        }
        return Optional.empty();
    }
}

