/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.domains;

import crawlercommons.domains.SuffixTrie;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.IDN;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.BoundedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveTldFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EffectiveTldFinder.class);
    public static final String ETLD_DATA = "/effective_tld_names.dat";
    public static final String COMMENT = "//";
    public static final String DOT_REGEX = "\\.";
    public static final String EXCEPTION = "!";
    public static final String WILD_CARD = "*.";
    public static final char DOT = '.';
    public static Pattern VERSION_PATTERN = Pattern.compile("^//\\s*(COMMIT|VERSION):\\s*(\\S+)");
    public static final int MAX_DOMAIN_LENGTH_PART = 63;
    private static EffectiveTldFinder instance = null;
    private Map<String, EffectiveTLD> domains = null;
    private SuffixTrie<EffectiveTLD> domainTrie = new SuffixTrie();
    private boolean configured = false;

    private EffectiveTldFinder() {
        URL publicSuffixList = this.getClass().getResource(ETLD_DATA);
        LOGGER.info("Loading public suffix list from class path: {}", (Object)publicSuffixList);
        try (InputStream is = publicSuffixList.openStream();){
            this.initialize(is);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load public suffix list {} from class path: {}", (Object)publicSuffixList, (Object)e);
        }
    }

    public static EffectiveTldFinder getInstance() {
        if (null == instance) {
            instance = new EffectiveTldFinder();
        }
        return instance;
    }

    public boolean initialize(InputStream effectiveTldDataStream) {
        this.domains = new HashMap<String, EffectiveTLD>();
        this.domainTrie = new SuffixTrie();
        boolean inPrivateDomainSection = false;
        try {
            int linesRead = 0;
            int rulesRead = 0;
            BoundedInputStream isCounting = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(effectiveTldDataStream)).get();
            FilterInputStream is = isCounting;
            ArrayList<MessageDigest> digests = new ArrayList<MessageDigest>();
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                is = new DigestInputStream(is, md5);
                digests.add(md5);
                MessageDigest sha512 = MessageDigest.getInstance("SHA-512");
                is = new DigestInputStream(is, sha512);
                digests.add(sha512);
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.warn("Failed to initialize digesting input streams", e);
            }
            BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
            String line = null;
            while (null != (line = input.readLine())) {
                ++linesRead;
                if (line.trim().isEmpty()) continue;
                if (line.startsWith(COMMENT)) {
                    if (line.contains("===BEGIN PRIVATE DOMAINS===")) {
                        inPrivateDomainSection = true;
                        continue;
                    }
                    if (line.contains("===END PRIVATE DOMAINS===")) {
                        inPrivateDomainSection = false;
                        continue;
                    }
                    Matcher m = VERSION_PATTERN.matcher(line);
                    if (!m.matches()) continue;
                    LOGGER.info("Public suffix list {}: {}", (Object)m.group(1), (Object)m.group(2));
                    continue;
                }
                ++rulesRead;
                EffectiveTLD entry = new EffectiveTLD(line, inPrivateDomainSection);
                for (String var : entry.getNameVariants()) {
                    this.domains.put(var, entry);
                    this.domainTrie.put(var, entry);
                }
            }
            this.configured = true;
            ((InputStream)is).close();
            long bytesRead = isCounting.getCount();
            LOGGER.info("Successfully read public suffix list: {} bytes, {} lines, {} rules", bytesRead, linesRead, rulesRead);
            for (MessageDigest digest : digests) {
                byte[] d = digest.digest();
                BigInteger bi = new BigInteger(1, d);
                String hexDigest = String.format(Locale.ROOT, "%0" + (d.length << 1) + "X", bi);
                LOGGER.info("Digest of public suffix list: {} = {}", (Object)digest.getAlgorithm(), (Object)hexDigest);
            }
        }
        catch (IOException e) {
            LOGGER.error("EffectiveTldFinder configuration failed: ", e);
            this.configured = false;
        }
        return this.configured;
    }

    public static Map<String, EffectiveTLD> getEffectiveTLDs() {
        return (Map)((HashMap)EffectiveTldFinder.getInstance().domains).clone();
    }

    public static EffectiveTLD getEffectiveTLD(String hostname) {
        return EffectiveTldFinder.getEffectiveTLD(hostname, false);
    }

    public static EffectiveTLD getEffectiveTLD(String hostname, boolean excludePrivate) {
        SuffixTrie.LookupResult<EffectiveTLD> res = EffectiveTldFinder.findEffectiveTLD(hostname, excludePrivate);
        if (res == null) {
            return null;
        }
        return (EffectiveTLD)res.value;
    }

    private static SuffixTrie.LookupResult<EffectiveTLD> findEffectiveTLD(String hostname, boolean excludePrivate) {
        List<SuffixTrie.LookupResult<EffectiveTLD>> suffixes = EffectiveTldFinder.getInstance().domainTrie.getSuffixes(hostname);
        for (int i = suffixes.size() - 1; i >= 0; --i) {
            SuffixTrie.LookupResult<EffectiveTLD> res = suffixes.get(i);
            int offset = res.offset;
            if (offset != 0 && '.' != hostname.charAt(offset - 1)) continue;
            EffectiveTLD foundTld = (EffectiveTLD)res.value;
            if (excludePrivate && foundTld.isPrivate || offset == 0 && foundTld.isWildcard()) continue;
            if (offset == 0 || foundTld.isException() || !foundTld.isWildcard()) {
                if (foundTld.idn != null) {
                    foundTld = new EffectiveTLD(hostname.substring(offset), foundTld);
                    return new SuffixTrie.LookupResult<EffectiveTLD>(offset, foundTld);
                }
                return res;
            }
            int wildcardOffset = hostname.lastIndexOf(46, offset - 2);
            String retryTld = wildcardOffset == -1 ? hostname : hostname.substring(wildcardOffset + 1);
            try {
                foundTld = new EffectiveTLD(retryTld, foundTld);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            return new SuffixTrie.LookupResult<EffectiveTLD>(wildcardOffset + 1, foundTld);
        }
        return null;
    }

    public static String getAssignedDomain(String hostname) {
        return EffectiveTldFinder.getAssignedDomain(hostname, false, false);
    }

    public static String getAssignedDomain(String hostname, boolean strict) {
        return EffectiveTldFinder.getAssignedDomain(hostname, strict, false);
    }

    public static String getAssignedDomain(String hostname, boolean strict, boolean excludePrivate) {
        String domainSegment;
        int pos;
        SuffixTrie.LookupResult<EffectiveTLD> res = EffectiveTldFinder.findEffectiveTLD(hostname = hostname.toLowerCase(Locale.ROOT), excludePrivate);
        if (res == null) {
            return strict ? null : hostname;
        }
        EffectiveTLD etld = (EffectiveTLD)res.value;
        if (etld.isException()) {
            return etld.domain;
        }
        if (res.offset == 0) {
            return strict ? null : hostname;
        }
        int etldStartPos = res.offset - 1;
        if (hostname.charAt(etldStartPos) != '.') {
            LOGGER.debug("No dot before eTLD {} in {}", (Object)hostname.substring(res.offset), (Object)hostname);
            return strict ? null : hostname;
        }
        int start = 0;
        while ((pos = hostname.indexOf(46, start)) != -1) {
            if (pos == start) {
                LOGGER.debug("Two immediately consecutive dots in hostname: {}", (Object)hostname);
                return strict ? null : hostname;
            }
            if (pos >= etldStartPos) break;
            start = pos + 1;
        }
        if (!EffectiveTLD.isAscii(domainSegment = hostname.substring(start, etldStartPos))) {
            try {
                IDN.toASCII(domainSegment);
            }
            catch (IllegalArgumentException e) {
                return strict ? null : hostname;
            }
        } else if (strict && domainSegment.length() > 63) {
            return null;
        }
        return hostname.substring(start);
    }

    public boolean isConfigured() {
        return this.configured;
    }

    private static String join(String[] ary) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ary.length; ++i) {
            sb.append(ary[i]).append('.');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static void help() {
        LOGGER.error("EffectiveTldFinder [-etld] [-strict] [-excludePrivate]");
        LOGGER.error("  get domains or public suffixes for host names");
        LOGGER.error("Options:");
        LOGGER.error("  -etld");
        LOGGER.error("       change mode: return public suffix (eTLD)");
        LOGGER.error("  -strict");
        LOGGER.error("       return null if no valid suffix/TLD is found");
        LOGGER.error("  -excludePrivate");
        LOGGER.error("       do not match suffixes from the private section of the public suffix list");
        LOGGER.error("Input is read from stdin, output on stdout: host \\t domain/eTLD");
    }

    public static void main(String[] args2) throws IOException {
        String line;
        boolean modeEtld = false;
        boolean strict = false;
        boolean excludePrivate = false;
        String[] stringArray = args2;
        int n = stringArray.length;
        block15: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "-etld": {
                    modeEtld = true;
                    continue block15;
                }
                case "-strict": {
                    strict = true;
                    continue block15;
                }
                case "-excludePrivate": {
                    excludePrivate = true;
                    continue block15;
                }
                case "-h": 
                case "-?": 
                case "-help": 
                case "--help": {
                    EffectiveTldFinder.help();
                    System.exit(0);
                }
                default: {
                    LOGGER.error("Unknown argument: {}", (Object)arg);
                    EffectiveTldFinder.help();
                    System.exit(1);
                }
            }
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        while ((line = in.readLine()) != null) {
            if (modeEtld) {
                EffectiveTLD etld = EffectiveTldFinder.getEffectiveTLD(line, excludePrivate);
                System.out.println(line + "\t" + String.valueOf(etld));
                continue;
            }
            String domain = EffectiveTldFinder.getAssignedDomain(line, strict, excludePrivate);
            System.out.println(line + "\t" + domain);
        }
    }

    public static class EffectiveTLD {
        private boolean exception = false;
        private boolean wildcard = false;
        private boolean isPrivate = false;
        private String domain = null;
        private String idn = null;
        private String suffix = null;

        public EffectiveTLD(String line, boolean isPrivateDomain) throws IllegalArgumentException {
            if (line.startsWith(EffectiveTldFinder.EXCEPTION)) {
                this.exception = true;
                this.domain = line.substring(EffectiveTldFinder.EXCEPTION.length(), line.length());
            } else if (line.startsWith(EffectiveTldFinder.WILD_CARD)) {
                this.wildcard = true;
                this.domain = line.substring(EffectiveTldFinder.WILD_CARD.length(), line.length());
            } else {
                this.domain = line;
            }
            String norm = this.normalizeName(this.domain);
            if (!norm.equals(this.domain)) {
                this.idn = this.domain;
                this.domain = norm;
            }
            this.suffix = this.domain;
            this.isPrivate = isPrivateDomain;
        }

        private EffectiveTLD(String representation, EffectiveTLD from) {
            this.domain = representation;
            this.suffix = from.domain;
            this.wildcard = from.wildcard;
            this.exception = from.exception;
            this.isPrivate = from.isPrivate;
            this.idn = from.idn;
        }

        private String normalizeName(String name) throws IllegalArgumentException {
            String[] parts = name.split(EffectiveTldFinder.DOT_REGEX);
            String[] ary = new String[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                ary[i] = EffectiveTLD.asciiConvert(parts[i]);
            }
            return EffectiveTldFinder.join(ary);
        }

        public Set<String> getNameVariants() {
            int i;
            HashSet<String> res = new HashSet<String>();
            if (this.idn == null) {
                res.add(this.domain);
                return res;
            }
            String[] parts = this.idn.split(EffectiveTldFinder.DOT_REGEX);
            String[] var = new String[parts.length];
            for (i = 0; i < parts.length; ++i) {
                if (EffectiveTLD.isAscii(parts[i])) continue;
                var[i] = IDN.toASCII(parts[i]);
            }
            for (i = 0; i < parts.length; ++i) {
                HashSet<Object> r = new HashSet<Object>();
                if (res.size() > 0) {
                    for (String p : res) {
                        r.add(p + "." + parts[i]);
                    }
                } else {
                    r.add(parts[i]);
                }
                if (var[i] != null && !var[i].equals(parts[i])) {
                    if (res.size() > 0) {
                        for (String p : res) {
                            r.add(p + "." + var[i]);
                        }
                    } else {
                        r.add(var[i]);
                    }
                }
                res = r;
            }
            return res;
        }

        private static String asciiConvert(String str) throws IllegalArgumentException {
            if (EffectiveTLD.isAscii(str)) {
                return str.toLowerCase(Locale.ROOT);
            }
            return IDN.toASCII(str);
        }

        private static boolean isAscii(String str) {
            char[] chars;
            for (char c : chars = str.toCharArray()) {
                if (c <= '\u007f') continue;
                return false;
            }
            return true;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getSuffix() {
            if (this.wildcard) {
                return EffectiveTldFinder.WILD_CARD + this.suffix;
            }
            if (this.exception) {
                return EffectiveTldFinder.EXCEPTION + this.suffix;
            }
            return this.suffix;
        }

        public String getUnicodeDomain() {
            return this.idn;
        }

        @Deprecated
        public boolean isWild() {
            return this.wildcard;
        }

        public boolean isWildcard() {
            return this.wildcard;
        }

        public boolean isException() {
            return this.exception;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[");
            sb.append("domain=").append(this.domain).append(",");
            sb.append("suffix=").append(this.getSuffix()).append(",");
            sb.append("idn=").append(this.idn).append(",");
            sb.append("wildcard=").append(this.wildcard).append(",");
            sb.append("exception=").append(this.exception).append(",");
            sb.append("private=").append(this.isPrivate).append("]");
            return sb.toString();
        }
    }
}

