/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax.extension;

import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.extension.ExtensionMetadata;
import crawlercommons.sitemaps.extension.VideoAttributes;
import crawlercommons.sitemaps.sax.extension.ExtensionHandler;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VideoHandler
extends ExtensionHandler {
    private VideoAttributes currAttr;
    private StringBuilder currVal;
    private String relationAttr;
    private Integer contentSegmentLocDuration;
    private VideoAttributes.TVShow tvShow;
    private Map<String, String> priceAttr;
    private static String[] PRICE_ATTRIBUTES = new String[]{"currency", "type", "resolution"};

    public VideoHandler() {
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.resetCurrent();
    }

    private void resetCurrent() {
        this.currAttr = null;
        this.currVal = new StringBuilder();
    }

    private Integer validateDuration(String value) {
        Integer duration = VideoHandler.getIntegerValue(value);
        if (duration != null && (duration < 0 || duration > 28800)) {
            SiteMapParser.LOG.debug("Invalid value for specified duration: {}", (Object)duration);
            return null;
        }
        return duration;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("video".equals(localName)) {
            if (this.currAttr != null) {
                this.attributes.add(this.currAttr);
            }
            this.resetCurrent();
            return;
        }
        if (this.currAttr == null) {
            this.currAttr = new VideoAttributes();
        }
        if ("restriction".equals(localName) || "platform".equals(localName)) {
            this.relationAttr = attributes.getValue("relationship");
        } else if ("gallery_loc".equals(localName)) {
            this.currAttr.setGalleryTitle(attributes.getValue("title"));
        } else if ("uploader".equals(localName)) {
            this.currAttr.setUploaderInfo(VideoHandler.getURLValue(attributes.getValue("info")));
        } else if ("price".equals(localName)) {
            this.priceAttr = new TreeMap<String, String>();
            for (String a : PRICE_ATTRIBUTES) {
                String v = attributes.getValue(a);
                if (v == null) continue;
                this.priceAttr.put(a, v);
            }
        } else if ("content_segment_loc".equals(localName)) {
            this.contentSegmentLocDuration = this.validateDuration(attributes.getValue("duration"));
        } else if ("tvshow".equals(localName)) {
            this.tvShow = new VideoAttributes.TVShow();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value = this.currVal.toString().trim().replaceAll("\\s+", " ");
        if ("video".equals(localName)) {
            if (this.currAttr != null) {
                this.attributes.add(this.currAttr);
            }
            this.resetCurrent();
            return;
        }
        if (this.currAttr == null) {
            this.currAttr = new VideoAttributes();
        }
        if ("price".equals(localName)) {
            Float fvalue = VideoHandler.getFloatValue(value);
            String currency = null;
            VideoAttributes.VideoPriceType type = VideoAttributes.VideoPriceType.own;
            VideoAttributes.VideoPriceResolution resolution = null;
            if (this.priceAttr != null) {
                String r;
                String t;
                if (this.priceAttr.containsKey("currency")) {
                    currency = this.priceAttr.get("currency").trim();
                }
                if ((t = this.priceAttr.get("type")) != null && !t.trim().isEmpty()) {
                    try {
                        type = VideoAttributes.VideoPriceType.valueOf(t.trim());
                    }
                    catch (IllegalArgumentException e) {
                        SiteMapParser.LOG.debug("Illegal value for price type: {}", (Object)type);
                    }
                }
                if ((r = this.priceAttr.get("resolution")) != null && !r.trim().isEmpty()) {
                    try {
                        resolution = VideoAttributes.VideoPriceResolution.valueOf(r.trim());
                    }
                    catch (IllegalArgumentException e) {
                        SiteMapParser.LOG.debug("Illegal value for price resolution: {}", (Object)resolution);
                    }
                }
            }
            VideoAttributes.VideoPrice price = new VideoAttributes.VideoPrice(currency, fvalue, type, resolution);
            this.currAttr.addPrice(price);
            this.priceAttr = null;
        } else if ("tvshow".equals(localName)) {
            this.currAttr.setTVShow(this.tvShow);
            this.tvShow = null;
        } else if (!value.isEmpty()) {
            if ("thumbnail_loc".equals(localName)) {
                this.currAttr.setThumbnailLoc(VideoHandler.getURLValue(value));
            } else if ("title".equals(localName)) {
                this.currAttr.setTitle(value);
            } else if ("description".equals(localName)) {
                this.currAttr.setDescription(value);
            } else if ("content_loc".equals(localName)) {
                this.currAttr.setContentLoc(VideoHandler.getURLValue(value));
            } else if ("player_loc".equals(localName)) {
                this.currAttr.setPlayerLoc(VideoHandler.getURLValue(value));
            } else if ("duration".equals(localName)) {
                this.currAttr.setDuration(this.validateDuration(value));
            } else if ("content_segment_loc".equals(localName)) {
                this.currAttr.addContentSegment(this.contentSegmentLocDuration, VideoHandler.getURLValue(value));
                this.contentSegmentLocDuration = null;
            } else if ("expiration_date".equals(localName)) {
                this.currAttr.setExpirationDate(VideoHandler.getDateValue(value));
            } else if ("rating".equals(localName)) {
                this.currAttr.setRating(VideoHandler.getFloatValue(value));
            } else if ("view_count".equals(localName)) {
                this.currAttr.setViewCount(VideoHandler.getIntegerValue(value));
            } else if ("publication_date".equals(localName)) {
                this.currAttr.setPublicationDate(VideoHandler.getDateValue(value));
            } else if ("family_friendly".equals(localName)) {
                this.currAttr.setFamilyFriendly(!"No".equalsIgnoreCase(value));
            } else if ("tag".equals(localName)) {
                this.currAttr.addTag(value);
            } else if ("category".equals(localName)) {
                this.currAttr.setCategory(value);
            } else if ("restriction".equals(localName)) {
                if (this.relationAttr != null) {
                    String[] vals = value.split("\\s+");
                    if ("allow".equalsIgnoreCase(this.relationAttr)) {
                        this.currAttr.setAllowedCountries(vals);
                    } else if ("deny".equalsIgnoreCase(this.relationAttr)) {
                        this.currAttr.setRestrictedCountries(vals);
                    }
                }
                this.relationAttr = null;
            } else if ("gallery_loc".equals(localName)) {
                this.currAttr.setGalleryLoc(VideoHandler.getURLValue(value));
            } else if ("requires_subscription".equals(localName)) {
                this.currAttr.setRequiresSubscription(VideoHandler.getYesNoBooleanValue(value, localName));
            } else if ("uploader".equals(localName)) {
                this.currAttr.setUploader(value);
            } else if ("platform".equals(localName)) {
                if (this.relationAttr != null) {
                    String[] vals = value.split("\\s+");
                    if ("allow".equalsIgnoreCase(this.relationAttr)) {
                        this.currAttr.setAllowedPlatforms(vals);
                    } else if ("deny".equalsIgnoreCase(this.relationAttr)) {
                        this.currAttr.setRestrictedPlatforms(vals);
                    }
                }
                this.relationAttr = null;
            } else if ("live".equals(localName)) {
                this.currAttr.setLive(VideoHandler.getYesNoBooleanValue(value, localName));
            } else if ("show_title".equals(localName)) {
                if (this.tvShow != null) {
                    this.tvShow.setShowTitle(value);
                } else {
                    SiteMapParser.LOG.debug("Element <show_title> outside enclosing element <tvshow>!");
                }
            } else if ("video_type".equals(localName)) {
                if (this.tvShow != null) {
                    this.tvShow.setVideoType(value);
                } else {
                    SiteMapParser.LOG.debug("Element <video_type> outside enclosing element <tvshow>!");
                }
            } else if ("episode_title".equals(localName)) {
                if (this.tvShow != null) {
                    this.tvShow.setEpisodeTitle(value);
                } else {
                    SiteMapParser.LOG.debug("Element <episode_title> outside enclosing element <tvshow>!");
                }
            } else if ("".equals(localName)) {
                if (this.tvShow != null) {
                    this.tvShow.setVideoType(value);
                } else {
                    SiteMapParser.LOG.debug("Element <> outside enclosing element <tvshow>!");
                }
            } else if ("season_number".equals(localName)) {
                if (this.tvShow != null) {
                    this.tvShow.setSeasonNumber(VideoHandler.getIntegerValue(value));
                } else {
                    SiteMapParser.LOG.debug("Element <season_number> outside enclosing element <tvshow>!");
                }
            } else if ("episode_number".equals(localName)) {
                if (this.tvShow != null) {
                    this.tvShow.setEpisodeNumber(VideoHandler.getIntegerValue(value));
                } else {
                    SiteMapParser.LOG.debug("Element <episode_number> outside enclosing element <tvshow>!");
                }
            } else if ("premier_date".equals(localName)) {
                if (this.tvShow != null) {
                    this.tvShow.setPremierDate(VideoHandler.getDateValue(value));
                } else {
                    SiteMapParser.LOG.debug("Element <premier_date> outside enclosing element <tvshow>!");
                }
            }
        }
        this.currVal = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currVal.append(String.valueOf(ch, start, length));
    }

    @Override
    public ExtensionMetadata[] getAttributes() {
        if (this.currAttr != null) {
            this.attributes.add(this.currAttr);
        }
        return super.getAttributes();
    }
}

