/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Locale;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="Checksum", strict=false)
public class Checksum {
    @Element(name="ChecksumCRC32", required=false)
    private String checksumCRC32;
    @Element(name="ChecksumCRC32C", required=false)
    private String checksumCRC32C;
    @Element(name="ChecksumCRC64NVME", required=false)
    private String checksumCRC64NVME;
    @Element(name="ChecksumSHA1", required=false)
    private String checksumSHA1;
    @Element(name="ChecksumSHA256", required=false)
    private String checksumSHA256;
    @Element(name="ChecksumType", required=false)
    private String checksumType;

    public String checksumCRC32() {
        return this.checksumCRC32;
    }

    public String checksumCRC32C() {
        return this.checksumCRC32C;
    }

    public String checksumCRC64NVME() {
        return this.checksumCRC64NVME;
    }

    public String checksumSHA1() {
        return this.checksumSHA1;
    }

    public String checksumSHA256() {
        return this.checksumSHA256;
    }

    public String checksumType() {
        return this.checksumType;
    }

    private void addHeader(Multimap<String, String> map, String algorithm, String value) {
        if (value != null || !value.isEmpty()) {
            map.put("x-amz-checksum-algorithm", algorithm);
            map.put("x-amz-checksum-algorithm-" + algorithm.toLowerCase(Locale.US), value);
        }
    }

    public Multimap<String, String> headers() {
        HashMultimap<String, String> map = HashMultimap.create();
        this.addHeader(map, "CRC32", this.checksumCRC32);
        this.addHeader(map, "CRC32C", this.checksumCRC32C);
        this.addHeader(map, "CRC64NVME", this.checksumCRC64NVME);
        this.addHeader(map, "SHA1", this.checksumSHA1);
        this.addHeader(map, "SHA256", this.checksumSHA256);
        return map;
    }
}

