/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.extension;

import crawlercommons.sitemaps.extension.ExtensionMetadata;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class NewsAttributes
extends ExtensionMetadata {
    public static final String NAME = "name";
    public static final String LANGUAGE = "language";
    public static final String GENRES = "genres";
    public static final String PUBLICATION_DATE = "publication_date";
    public static final String TITLE = "title";
    public static final String ACCESS = "access";
    public static final String KEYWORDS = "keywords";
    public static final String STOCK_TICKERS = "stock_tickers";
    private String name;
    private String language;
    private NewsGenre[] genres;
    private ZonedDateTime publicationDate;
    private String title;
    private String[] keywords;
    private String[] stockTickers;
    private AccessOption access;

    public NewsAttributes() {
    }

    public NewsAttributes(String name, String language, ZonedDateTime publicationDate, String title) {
        this.name = name;
        this.language = language;
        this.publicationDate = publicationDate;
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public NewsGenre[] getGenres() {
        return this.genres;
    }

    public void setGenres(NewsGenre[] genres) {
        this.genres = genres;
    }

    public Date getPublicationDate() {
        if (this.publicationDate != null) {
            return Date.from(this.publicationDate.toInstant());
        }
        return null;
    }

    public ZonedDateTime getPublicationDateTime() {
        return this.publicationDate;
    }

    public void setPublicationDate(ZonedDateTime publicationDate) {
        this.publicationDate = publicationDate;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    public String[] getStockTickers() {
        return this.stockTickers;
    }

    public void setStockTickers(String[] stockTickers) {
        this.stockTickers = stockTickers;
    }

    public AccessOption getAccess() {
        return this.access;
    }

    public void setAccess(String access) {
        this.access = AccessOption.valueOf(access);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof NewsAttributes)) {
            return false;
        }
        NewsAttributes that = (NewsAttributes)other;
        return Objects.equals(this.name, that.name) && Objects.equals(this.language, that.language) && Objects.equals(this.title, that.title) && Objects.equals(this.publicationDate, that.publicationDate) && Objects.equals((Object)this.access, (Object)that.access) && Objects.deepEquals(this.keywords, that.keywords) && Objects.deepEquals(this.genres, that.genres) && Objects.deepEquals(this.stockTickers, that.stockTickers);
    }

    @Override
    public boolean isValid() {
        return this.name != null && this.language != null && this.publicationDate != null && this.title != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("News name: ").append(this.name);
        sb.append(", title: ").append(this.title);
        sb.append(", language: ").append(this.language);
        sb.append(", publication-date: ").append(this.publicationDate);
        if (this.keywords != null) {
            sb.append(", keywords: ").append(String.join((CharSequence)", ", this.keywords));
        }
        if (this.genres != null) {
            sb.append(", genres: ");
            for (int i = 0; i < this.genres.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.genres[i].toString());
            }
        }
        if (this.stockTickers != null) {
            sb.append(", stock_tickers: ").append(String.join((CharSequence)", ", this.stockTickers));
        }
        if (this.access != null) {
            sb.append(", access: ").append((Object)this.access);
        }
        return sb.toString();
    }

    @Override
    public Map<String, String[]> asMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (this.name != null) {
            map.put(NAME, new String[]{this.name});
        }
        if (this.title != null) {
            map.put(TITLE, new String[]{this.title});
        }
        if (this.language != null) {
            map.put(LANGUAGE, new String[]{this.language});
        }
        if (this.publicationDate != null) {
            map.put(PUBLICATION_DATE, new String[]{this.publicationDate.toString()});
        }
        if (this.keywords != null) {
            map.put(KEYWORDS, this.keywords);
        }
        if (this.genres != null) {
            String[] genresStrArr = (String[])Arrays.stream(this.genres).map(Enum::name).toArray(String[]::new);
            map.put(GENRES, genresStrArr);
        }
        if (this.stockTickers != null) {
            map.put(STOCK_TICKERS, this.stockTickers);
        }
        return map;
    }

    public static enum AccessOption {
        Subscription,
        Registration;

    }

    public static enum NewsGenre {
        Blog,
        OpEd,
        Opinion,
        PressRelease,
        Satire,
        UserGenerated;

    }
}

