/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax.extension;

import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.extension.ExtensionMetadata;
import crawlercommons.sitemaps.extension.NewsAttributes;
import crawlercommons.sitemaps.sax.extension.ExtensionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NewsHandler
extends ExtensionHandler {
    private NewsAttributes currAttr;
    private StringBuilder currVal;

    public NewsHandler() {
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.resetCurrent();
    }

    private void resetCurrent() {
        this.currAttr = null;
        this.currVal = new StringBuilder();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("news".equals(localName)) {
            if (this.currAttr != null) {
                this.attributes.add(this.currAttr);
            }
            this.resetCurrent();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value = this.currVal.toString().trim();
        if ("news".equals(localName)) {
            if (this.currAttr != null) {
                this.attributes.add(this.currAttr);
            }
            this.resetCurrent();
            return;
        }
        if (this.currAttr == null) {
            this.currAttr = new NewsAttributes();
        }
        if (!value.isEmpty()) {
            if ("title".equals(localName)) {
                this.currAttr.setTitle(value);
            } else if ("name".equals(localName)) {
                this.currAttr.setName(value);
            } else if ("language".equals(localName)) {
                this.currAttr.setLanguage(value);
            } else if ("publication_date".equals(localName)) {
                this.currAttr.setPublicationDate(NewsHandler.getDateValue(value));
            } else if ("genres".equals(localName)) {
                String[] genresList = commaSeparated.split(value);
                ArrayList<NewsAttributes.NewsGenre> _genres = new ArrayList<NewsAttributes.NewsGenre>();
                for (String genre : genresList) {
                    try {
                        _genres.add(NewsAttributes.NewsGenre.valueOf(genre.trim()));
                    }
                    catch (IllegalArgumentException e) {
                        SiteMapParser.LOG.debug("Unsupported news sitemap genre: {}", (Object)genre);
                    }
                }
                this.currAttr.setGenres(_genres.toArray(new NewsAttributes.NewsGenre[_genres.size()]));
            } else if ("keywords".equals(localName)) {
                this.currAttr.setKeywords(commaSeparated.split(value));
            } else if ("stock_tickers".equals(localName)) {
                String[] stockTickers = commaSeparated.split(value);
                if (stockTickers.length > 5) {
                    stockTickers = Arrays.copyOfRange(stockTickers, 0, 5);
                }
                this.currAttr.setStockTickers(stockTickers);
            } else if ("access".equals(localName)) {
                this.currAttr.setAccess(value);
            }
        }
        this.currVal = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currVal.append(String.valueOf(ch, start, length));
    }

    @Override
    public ExtensionMetadata[] getAttributes() {
        if (this.currAttr != null) {
            this.attributes.add(this.currAttr);
        }
        return super.getAttributes();
    }
}

