/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.JensenShannonDistance;
import com.wcohen.ss.api.Token;
import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.tokens.SimpleTokenizer;

public class DirichletJS
extends JensenShannonDistance {
    private double pseudoCount = 1.0;

    public double getPseudoCount() {
        return this.pseudoCount;
    }

    public void setPseudoCount(double c) {
        this.pseudoCount = c;
    }

    public void setPseudoCount(Double c) {
        this.pseudoCount = c;
    }

    public DirichletJS(Tokenizer tokenizer, double pseudoCount) {
        super(tokenizer);
        this.setPseudoCount(pseudoCount);
    }

    public DirichletJS() {
        this(SimpleTokenizer.defaultTokenizer(), 1.0);
    }

    public String toString() {
        return "[DirichletJS pcount=" + this.pseudoCount + "]";
    }

    @Override
    protected double smoothedProbability(Token tok, double freq, double totalWeight) {
        return (freq + this.pseudoCount * this.backgroundProb(tok)) / (totalWeight + this.pseudoCount);
    }

    public static void main(String[] argv) {
        DirichletJS.doMain(new DirichletJS(), argv);
    }
}

