/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.cls.expt.EvaluationGroup;
import com.wcohen.ss.DirichletJS;
import com.wcohen.ss.Jaccard;
import com.wcohen.ss.Jaro;
import com.wcohen.ss.JaroWinkler;
import com.wcohen.ss.JaroWinklerTFIDF;
import com.wcohen.ss.JelinekMercerJS;
import com.wcohen.ss.Levenstein;
import com.wcohen.ss.MongeElkan;
import com.wcohen.ss.TagLink;
import com.wcohen.ss.TokenFelligiSunter;
import com.wcohen.ss.api.StringDistanceLearner;
import com.wcohen.ss.expt.Blocker;
import com.wcohen.ss.expt.MatchData;
import com.wcohen.ss.expt.MatchExpt;
import com.wcohen.ss.expt.NGramBlocker;
import com.wcohen.ss.expt.NullBlocker;
import com.wcohen.ss.expt.TokenBlocker;
import com.wcohen.util.IOUtil;
import com.wcohen.util.ProgressCounter;
import com.wcohen.util.gui.ComponentViewer;
import com.wcohen.util.gui.TypeSelector;
import com.wcohen.util.gui.Viewer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jwf.NullWizardPanel;
import jwf.Wizard;
import jwf.WizardAdapter;
import jwf.WizardListener;
import jwf.WizardPanel;

public class WizardUI {
    private static final Blocker DEFAULT_BLOCKER = new NullBlocker();
    private static final StringDistanceLearner DEFAULT_DISTANCE = new JaroWinklerTFIDF();

    public static void main(String[] args) {
        JFrame frame = new JFrame("SecondString");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        Wizard wizard = new Wizard();
        wizard.addWizardListener((WizardListener)new WizardAdapter(){

            public void wizardFinished(Wizard wizard) {
                System.exit(0);
            }

            public void wizardCancelled(Wizard wizard) {
                System.exit(0);
            }
        });
        frame.setContentPane((Container)wizard);
        frame.pack();
        frame.setVisible(true);
        wizard.start((WizardPanel)new PickTask());
    }

    private static class SaveResults
    extends WizardViewer {
        private boolean fileWasSaved = false;

        public SaveResults(Map viewerContext) {
            super("SavedResult", viewerContext);
        }

        @Override
        public WizardPanel buildWizardPanel() {
            return new SaveResultPanel((Viewer)this);
        }

        private class SaveResultPanel
        extends NullWizardPanel {
            public SaveResultPanel(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: save results?"));
                this.add(new JLabel("Select a file to store these results in:"));
                final JTextField filePane = new JTextField(20);
                filePane.setEditable(false);
                this.add(filePane);
                final JFileChooser chooser = new JFileChooser();
                this.add(new JButton(new AbstractAction("Browse"){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        int returnVal = chooser.showSaveDialog(null);
                        if (returnVal == 0) {
                            File file = chooser.getSelectedFile();
                            filePane.setText(file.getName());
                            Object evaluation = ((Viewer)SaveResults.this.viewerContext.get("ExptViewer")).getContent();
                            try {
                                IOUtil.saveSerialized((Serializable)((Serializable)evaluation), (File)file);
                                SaveResults.this.fileWasSaved = true;
                            }
                            catch (IOException ex) {
                                System.err.println("error saving: " + ex);
                            }
                        }
                    }
                }));
            }

            public boolean canFinish() {
                return true;
            }

            public boolean validateFinish(List list) {
                list.add("You haven't saved the results. Click cancel to exit without saving them");
                return SaveResults.this.fileWasSaved;
            }
        }
    }

    private static class ResultWizardPanel
    extends NullWizardPanel {
        WizardPanel nextPanel = null;

        public ResultWizardPanel(Viewer v, WizardPanel nextPanel) {
            this.nextPanel = nextPanel;
            this.setBorder(new TitledBorder("SecondString: results"));
            this.add((Component)v);
        }

        public boolean hasNext() {
            return this.nextPanel != null;
        }

        public boolean validateNext(List list) {
            return this.nextPanel != null;
        }

        public WizardPanel next() {
            return this.nextPanel;
        }
    }

    private static class ShowResults
    extends WizardViewer {
        public ShowResults(Map viewerContext) {
            super("Result", viewerContext);
        }

        @Override
        public WizardPanel buildWizardPanel() {
            return new ResultWizardPanel((Viewer)this.viewerContext.get("ExptViewer"), new SaveResults(this.viewerContext).getWizardPanel());
        }
    }

    private static class RunExperiment
    extends WizardViewer {
        private MatchExpt matchExpt;
        private Viewer matchExptViewer;
        private boolean matchExptComplete = false;

        public RunExperiment(Map viewerContext) {
            super("none", viewerContext);
        }

        @Override
        public WizardPanel buildWizardPanel() {
            return new RunExperimentWizard((Viewer)this);
        }

        private class ResultWizardPanel
        extends NullWizardPanel {
            public ResultWizardPanel(Viewer v) {
                this.setBorder(new TitledBorder("SecondString: results"));
                this.add((Component)v);
            }
        }

        private class RunExperimentWizard
        extends NullWizardPanel {
            public RunExperimentWizard(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: confirm and run experiment"));
                this.setLayout(new GridBagLayout());
                String[] keys = new String[]{"Blocker", "Distance", "File"};
                Object[][] tableData = new Object[keys.length][2];
                for (int i = 0; i < keys.length; ++i) {
                    tableData[i][0] = keys[i];
                    tableData[i][1] = RunExperiment.this.viewerContext.get(keys[i]);
                }
                JTable table = new JTable(tableData, new String[]{"Parameter", "Value"});
                JScrollPane tableScroller = new JScrollPane(table);
                tableScroller.setHorizontalScrollBarPolicy(30);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.weighty = 1.0;
                gbc.weightx = 1.0;
                gbc.fill = 1;
                this.add(tableScroller, gbc);
                final JPanel progressPanel = new JPanel();
                progressPanel.setBorder(new TitledBorder("Progress on Experiment"));
                JProgressBar progressBar = new JProgressBar();
                progressPanel.add(new JButton(new AbstractAction("Start Experiment"){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        final Blocker blocker = (Blocker)RunExperiment.this.viewerContext.get("Blocker");
                        final StringDistanceLearner learner = (StringDistanceLearner)RunExperiment.this.viewerContext.get("Distance");
                        File datafile = (File)RunExperiment.this.viewerContext.get("File");
                        final MatchData data = new MatchData(datafile.getAbsolutePath());
                        Thread exptThread = new Thread(){

                            @Override
                            public void run() {
                                RunExperiment.this.matchExpt = new MatchExpt(data, learner, blocker);
                                RunExperiment.this.matchExptViewer = RunExperiment.this.matchExpt.toGUI();
                                RunExperiment.this.viewerContext.put("MatchExpt", RunExperiment.this.matchExpt);
                                RunExperiment.this.viewerContext.put("ExptViewer", RunExperiment.this.matchExptViewer);
                                RunExperiment.this.matchExptComplete = true;
                                progressPanel.add(new JLabel("Experiment complete!"));
                                progressPanel.revalidate();
                            }
                        };
                        exptThread.start();
                    }
                }));
                ProgressCounter.setGraphicContext((JProgressBar[])new JProgressBar[]{progressBar});
                progressPanel.add(progressBar);
                gbc = new GridBagConstraints();
                gbc.weightx = 1.0;
                gbc.weighty = 0.5;
                gbc.gridy = 1;
                gbc.fill = 2;
                this.add(progressPanel, gbc);
            }

            public boolean hasNext() {
                return true;
            }

            public boolean validateNext(List list) {
                list.clear();
                list.add("You need to run the experiment and wait for it to finish before you can go to the next step.");
                return RunExperiment.this.matchExptComplete;
            }

            public WizardPanel next() {
                return new ShowResults(RunExperiment.this.viewerContext).getWizardPanel();
            }
        }
    }

    private static class PickDatafile
    extends WizardViewer {
        public PickDatafile(Map viewerContext) {
            super("File", viewerContext);
        }

        @Override
        public WizardPanel buildWizardPanel() {
            return new DatafileWizardPanel((Viewer)this);
        }

        private class DatafileWizardPanel
        extends NullWizardPanel {
            public DatafileWizardPanel(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: datafile selection"));
                this.add(new JLabel("Please select a datafile:"));
                final JTextField filePane = new JTextField(20);
                this.add(filePane);
                final JFileChooser chooser = new JFileChooser();
                this.add(new JButton(new AbstractAction("Browse"){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        int returnVal = chooser.showOpenDialog(null);
                        if (returnVal == 0) {
                            PickDatafile.this.viewerContext.put("File", chooser.getSelectedFile());
                            filePane.setText(((File)PickDatafile.this.viewerContext.get("File")).getName());
                        }
                    }
                }));
            }

            public boolean hasNext() {
                return true;
            }

            public boolean validateNext(List list) {
                list.add("You need to pick a file!");
                return PickDatafile.this.viewerContext.get("File") != null;
            }

            public WizardPanel next() {
                return new RunExperiment(PickDatafile.this.viewerContext).getWizardPanel();
            }
        }
    }

    private static class PickDistance
    extends WizardViewer {
        public PickDistance(Map viewerContext) {
            super("Distance", viewerContext);
        }

        @Override
        public WizardPanel buildWizardPanel() {
            return new DistanceWizardPanel((Viewer)this);
        }

        private class DistanceWizardPanel
        extends NullWizardPanel {
            public DistanceWizardPanel(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: distance selection"));
                this.add(new JLabel("Please select a string distance:"));
                SSTypeSelector selector = new SSTypeSelector(StringDistanceLearner.class);
                selector.setSuperView(enclosingViewer);
                selector.receiveContent(DEFAULT_DISTANCE);
                PickDistance.this.viewerContext.put("Distance", DEFAULT_DISTANCE);
                this.add((Component)((Object)selector));
            }

            public boolean hasNext() {
                return true;
            }

            public boolean validateNext(List list) {
                return true;
            }

            public WizardPanel next() {
                return new PickDatafile(PickDistance.this.viewerContext).getWizardPanel();
            }
        }
    }

    private static class PickBlocker
    extends WizardViewer {
        public PickBlocker() {
            super("Blocker");
        }

        @Override
        public WizardPanel buildWizardPanel() {
            return new BlockerWizardPanel((Viewer)this);
        }

        private class BlockerWizardPanel
        extends NullWizardPanel {
            public BlockerWizardPanel(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: blocker selection"));
                this.add(new JLabel("Please select a blocking strategy:"));
                SSTypeSelector selector = new SSTypeSelector(Blocker.class);
                selector.setSuperView(enclosingViewer);
                selector.receiveContent(DEFAULT_BLOCKER);
                PickBlocker.this.viewerContext.put("Blocker", DEFAULT_BLOCKER);
                this.add((Component)((Object)selector));
            }

            public boolean hasNext() {
                return true;
            }

            public boolean validateNext(List list) {
                return true;
            }

            public WizardPanel next() {
                return new PickDistance(PickBlocker.this.viewerContext).getWizardPanel();
            }

            public boolean hasHelp() {
                return true;
            }

            public void help() {
                String helpMsg = "A \"blocker\" is used to make an initial guess about which pairs to match.\nThe NullBlocker picks all pairs; the TokenBlocker picks all pairs that share\na common token; and the NGramBlocker picks all pairs that share a common NGram.";
                JOptionPane.showMessageDialog((Component)((Object)this), helpMsg, "Blocker Help", 1);
            }
        }
    }

    private static class PickExptFile
    extends WizardViewer {
        private MatchExpt matchExpt = null;
        private EvaluationGroup evalGroup = new EvaluationGroup();
        private int groupSize = 0;

        public PickExptFile() {
            super("ExptFile");
        }

        @Override
        public WizardPanel buildWizardPanel() {
            return new ExptFileWizardPanel((Viewer)this);
        }

        private class ExptFileWizardPanel
        extends NullWizardPanel {
            public ExptFileWizardPanel(Viewer enclosingViewer) {
                this.setBorder(new TitledBorder("SecondString: saved experiment selection"));
                this.add(new JLabel("Please select one or more previously-saved experiments:"));
                final JTextField filePane = new JTextField(20);
                this.add(filePane);
                final ArrayList exptListData = new ArrayList();
                final JList exptList = new JList();
                Dimension wide = new Dimension(600, 100);
                exptList.setPreferredSize(wide);
                final JFileChooser chooser = new JFileChooser();
                this.add(new JButton(new AbstractAction("Browse"){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        int returnVal = chooser.showOpenDialog(null);
                        if (returnVal == 0) {
                            File exptFile = chooser.getSelectedFile();
                            filePane.setText(exptFile.getName());
                            try {
                                PickExptFile.this.matchExpt = (MatchExpt)IOUtil.loadSerialized((File)exptFile);
                                exptListData.add(PickExptFile.this.matchExpt);
                                PickExptFile.this.evalGroup.add(exptFile.getName(), PickExptFile.this.matchExpt.toEvaluation());
                                PickExptFile.this.groupSize++;
                                exptList.setListData(exptListData.toArray());
                            }
                            catch (IOException ex) {
                                System.err.println("can't load " + exptFile + ": " + ex);
                            }
                        }
                    }
                }));
                JPanel listPanel = new JPanel();
                listPanel.setPreferredSize(wide);
                listPanel.setBorder(new TitledBorder("Selected experiments"));
                JScrollPane scroller = new JScrollPane(exptList);
                scroller.setPreferredSize(wide);
                listPanel.add(scroller);
                this.add(listPanel);
            }

            public boolean hasNext() {
                return true;
            }

            public boolean validateNext(List list) {
                list.add("You need to pick a file!");
                return PickExptFile.this.groupSize >= 1;
            }

            public WizardPanel next() {
                if (PickExptFile.this.groupSize == 1) {
                    return new ResultWizardPanel(PickExptFile.this.matchExpt.toGUI(), null);
                }
                return new ResultWizardPanel(PickExptFile.this.evalGroup.toGUI(), null);
            }
        }
    }

    private static class PickTask
    extends NullWizardPanel {
        private JRadioButton doExpt;
        private JRadioButton reviewResult;

        public PickTask() {
            this.setBorder(new TitledBorder("SecondString: task selection"));
            this.add(new JLabel("Welcome to SecondString!"));
            this.add(new JLabel("Please select a task:"));
            this.doExpt = new JRadioButton("Perform an experiment", true);
            this.reviewResult = new JRadioButton("Review saved experimental results", false);
            ButtonGroup group = new ButtonGroup();
            this.add(this.doExpt);
            this.add(this.reviewResult);
            group.add(this.doExpt);
            group.add(this.reviewResult);
        }

        public boolean hasNext() {
            return true;
        }

        public boolean validateNext(List list) {
            return true;
        }

        public WizardPanel next() {
            if (this.doExpt.isSelected()) {
                return new PickBlocker().getWizardPanel();
            }
            return new PickExptFile().getWizardPanel();
        }
    }

    private static class SSTypeSelector
    extends TypeSelector {
        private static Class[] ssClasses = new Class[]{NullBlocker.class, TokenBlocker.class, NGramBlocker.class, DirichletJS.class, JelinekMercerJS.class, Jaccard.class, Jaro.class, JaroWinkler.class, JaroWinklerTFIDF.class, Levenstein.class, MongeElkan.class, TokenFelligiSunter.class, TagLink.class};

        public SSTypeSelector(Class rootClass) {
            super(ssClasses, rootClass);
        }
    }

    private static abstract class WizardViewer
    extends ComponentViewer {
        private String myKey;
        protected final Map<String, Object> viewerContext;
        private final WizardPanel wizardPanel;

        public WizardViewer(String key, Map viewerContext) {
            this.myKey = key;
            this.viewerContext = viewerContext;
            this.wizardPanel = this.buildWizardPanel();
        }

        public WizardViewer(String key) {
            this(key, new HashMap());
        }

        public WizardPanel getWizardPanel() {
            return this.wizardPanel;
        }

        public JComponent componentFor(Object o) {
            return this.wizardPanel;
        }

        public boolean canHandle(int signal, Object argument, ArrayList senders) {
            return signal == 3;
        }

        public void handle(int signal, Object argument, ArrayList senders) {
            if (signal == 3) {
                System.out.println("selected " + argument);
                this.viewerContext.put(this.myKey, argument);
            }
        }

        public abstract WizardPanel buildWizardPanel();
    }
}

