/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.lookup;

import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.lookup.FastLookup;
import com.wcohen.ss.lookup.LookupResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RescoringSoftTFIDFDictionary
implements FastLookup {
    private StringDistance rescorer;
    private FastLookup inner;
    private double innerMinScore;
    private List<LookupResult> result;

    public RescoringSoftTFIDFDictionary(FastLookup inner, double innerMinScore, StringDistance rescorer) {
        this.inner = inner;
        this.rescorer = rescorer;
        this.innerMinScore = innerMinScore;
    }

    @Override
    public int lookup(double minScore, String toFind) {
        this.result = new ArrayList<LookupResult>();
        int n = this.inner.lookup(this.innerMinScore, toFind);
        if (n > 0) {
            StringWrapper w = this.rescorer.prepare(toFind);
            this.rescore(n, minScore, w);
        }
        return this.result.size();
    }

    private void rescore(int n, double minScore, StringWrapper w) {
        for (int i = 0; i < n; ++i) {
            String si = this.inner.getResult(i);
            double di = this.rescorer.score(w, this.rescorer.prepare(si));
            if (!(di >= minScore)) continue;
            this.result.add(new LookupResult(si, this.inner.getValue(i), di));
        }
        Collections.sort(this.result);
    }

    @Override
    public String getResult(int i) {
        return this.result.get((int)i).found;
    }

    @Override
    public Object getValue(int i) {
        return this.result.get((int)i).value;
    }

    @Override
    public double getScore(int i) {
        return this.result.get((int)i).score;
    }
}

