/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardClientHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobImpl;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobRegistry;
import eu.dnetlib.msro.workflows.nodes.ProcessNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BlackboardJobNode
extends ProcessNode {
    private static final Log log = LogFactory.getLog(BlackboardJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private BlackboardClientHandler blackboardClientHandler;
    @Autowired
    private BlackboardJobRegistry jobRegistry;

    @Override
    public final void execute(Token token) {
        log.info((Object)"executing blackboard node");
        try {
            token.getEnv().setAttribute("blackboard:isBlackboard", true);
            String serviceId = this.obtainServiceId(token.getEnv());
            if (StringUtils.isBlank((CharSequence)serviceId)) {
                String msg = "cannot locate target service profile: " + serviceId;
                log.error((Object)msg);
                token.releaseAsFailed(msg);
                token.release();
                return;
            }
            BlackboardJob job = this.blackboardClientHandler.newJob(serviceId);
            token.getEnv().setAttribute("blackboard:job", job);
            token.getEnv().setAttribute("blackboard:serviceId", ((BlackboardJobImpl)job).getServiceId());
            this.prepareJob(job, token);
            this.jobRegistry.registerJobListener(job, (BlackboardJobListener)this.generateBlackboardListener(token));
            this.blackboardClientHandler.assign(job);
        }
        catch (Throwable e) {
            log.error((Object)"cannot prepare blackboard job", e);
            token.releaseAsFailed(e);
        }
    }

    protected abstract String obtainServiceId(Env var1);

    protected abstract void prepareJob(BlackboardJob var1, Token var2) throws Exception;

    protected BlackboardWorkflowJobListener generateBlackboardListener(Token token) {
        return new BlackboardWorkflowJobListener(token);
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }
}

