package eu.dnetlib.ariadneplus.elasticsearch.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;

import java.util.Map;

public class AriadneTemporal {
    private String from;
    private String periodName;
    private String until;
    private String uri;

    public static AriadneTemporal fromRDFJson(JsonElement json) {
        AriadneTemporal at = new AriadneTemporal();
        for (Map.Entry<String, JsonElement> entry : json.getAsJsonObject().entrySet()){
            switch (entry.getKey()){
                case "https://www.ariadne-infrastructure.eu/property/from" :
                    at.setFrom(entry.getValue().getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString());
                    break;
                case "https://www.ariadne-infrastructure.eu/property/periodName":
                    at.setPeriodName(entry.getValue().getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString());
                    break;
                case "https://www.ariadne-infrastructure.eu/property/until":
                    at.setUntil(entry.getValue().getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString());
                    break;
                case "https://www.ariadne-infrastructure.eu/property/uri":
                    at.setUri(entry.getValue().getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString());
                    break;

            }
        }

        return at;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getPeriodName() {
        return periodName;
    }

    public void setPeriodName(String periodName) {
        this.periodName = periodName;
    }

    public String getUntil() {
        return until;
    }

    public void setUntil(String until) {
        this.until = until;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public AriadneTemporal() {
    }

    public static AriadneTemporal fromJson(String json){
        return new Gson().fromJson(json, AriadneTemporal.class);
    }
}
