/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.elasticsearch;

import eu.dnetlib.ariadneplus.elasticsearch.model.AatSubject;
import eu.dnetlib.ariadneplus.elasticsearch.model.AriadneCatalogEntry;
import eu.dnetlib.ariadneplus.elasticsearch.model.Spatial;
import eu.dnetlib.ariadneplus.reader.ResourceManager;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BulkUpload {
    private static final Log log = LogFactory.getLog(BulkUpload.class);
    @Value(value="${elasticsearch.hostname}")
    private String elasticSearchHostName;
    @Value(value="${elasticsearch.indexname}")
    private String elasticSearchIndexName;
    private RestHighLevelClient client;

    public void init(String elasticSearchHostName, String elasticSearchIndexName) throws IOException {
        this.elasticSearchIndexName = elasticSearchIndexName;
        this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(elasticSearchHostName, 9200, "http")}));
    }

    @PostConstruct
    public void init() throws IOException {
        this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.elasticSearchHostName, 9200, "http")}));
    }

    public int index(ResourceManager manager, boolean isCollection) {
        BulkRequest request = new BulkRequest();
        int esResponseCode = 0;
        while (manager.hasNext()) {
            try {
                Object next = manager.next();
                AriadneCatalogEntry ace = (AriadneCatalogEntry)next;
                if (isCollection) {
                    ace.setResourceType("collection");
                    if (ace.getSpatial() == null) {
                        ace.setSpatial(Arrays.asList(new Spatial()));
                    }
                } else {
                    ace.setResourceType("dataset");
                    Spatial esSpatial = new Spatial();
                    ace.getSpatial().stream().filter(s -> s.getPlaceName() != null).forEach(s -> esSpatial.setPlaceName(s.getPlaceName()));
                    ace.getSpatial().stream().filter(s -> s.getLocation() != null).forEach(s -> esSpatial.setLocation(s.getLocation()));
                    ace.getSpatial().clear();
                    ace.setSpatial(Arrays.asList(esSpatial));
                }
                if (!isCollection) {
                    String uniqueIsPartOf = ace.getUniqueIsPartOf();
                    if (uniqueIsPartOf != null) {
                        ace.setIsPartOf(Arrays.asList(uniqueIsPartOf));
                    }
                    if (ace.getContributor() != null) {
                        ace.getContributor().clear();
                        ace.setContributor(ace.getCreator());
                    }
                }
                String[] splits = ace.getIdentifier().split("/");
                if (ace.getAatSubjects() != null && ace.getDerivedSubject() != null) {
                    String aatSource = ((AatSubject)ace.getAatSubjects().get(0)).getId();
                    ace.getDerivedSubject().forEach(d -> d.setSource(aatSource));
                    String[] aatSourceSplit = aatSource.split("/");
                    String aatSubjectId = aatSourceSplit[aatSourceSplit.length - 1];
                    ace.getAatSubjects().forEach(s -> s.setId(aatSubjectId));
                }
                String idES = splits[splits.length - 1];
                request.add(new IndexRequest(this.elasticSearchIndexName).id(idES).source(ace.toJson(), XContentType.JSON));
                long start = System.currentTimeMillis();
                BulkResponse bulkResponse = this.client.bulk(request, RequestOptions.DEFAULT);
                long end = System.currentTimeMillis();
                if (bulkResponse != null) {
                    esResponseCode = bulkResponse.status().getStatus();
                    if (bulkResponse.hasFailures()) {
                        log.error((Object)("FailureMessage: " + bulkResponse.buildFailureMessage()));
                    }
                } else {
                    esResponseCode = -3;
                }
                log.debug((Object)(idES + " es_index_time(sec): " + (end - start) / 1000L + " response_code: " + esResponseCode));
            }
            catch (Throwable t) {
                t.printStackTrace();
                log.error((Object)("Indexing " + t.getMessage()));
                return -1;
            }
        }
        return esResponseCode;
    }
}

