package eu.dnetlib.ariadneplus.elasticsearch.model;

import com.google.gson.Gson;
import eu.dnetlib.ariadneplus.reader.utils.ESUtils;

import java.util.List;

public class AriadneCatalogEntry {
    private List<AatSubject> aatSubjects;
    private String  accessPolicy;
    private String accessRights;
    private ArchaeologicalResourceType archaeologicalResourceType;
    private List<AgentInfo> contributor;
    private List<AgentInfo> creator;
    private List<DerivedSubject> derivedSubject;
    private String description;
    private List <Distribution> distribution;
    private List<AgentInfo> publisher;
    private String title;
    private List<ItemMetadataStructure> hasItemMetadataStructure;
    private List<MetadataRecord> hasMetadataRecord;
    private String identifier;
    private List<String> isPartOf;
    private transient String uniqueIsPartOf;
    private String issued;
    private List<String> keyword;
    private String landingPage;
    private String language;
    private List<AgentInfo> legalResponsible;
    private String modified;
    private List<NativeSubject> nativeSubject;
    private String originalId;
    private List<AgentInfo> owner;
    private String resourceType;
    private String rdfType;
    private List<AgentInfo> scientificResponsible;
    private List<Spatial> spatial;
//    private List<SpatialRegion> spatialRegion;
//    private List<SpatialRegionPoint> spatialRegionPoint;
    private List<AgentInfo> technicalResponsible;
    private List<AriadneTemporal> temporal;

    private String accrualPeriodicity;// = new String("");
    private String audience;// IF PRESENT, MUST CONTAIN A VALUE !!
    private String contactPoint;// = new String("");
    private String extent;// IF PRESENT, MUST CONTAIN A VALUE !!
    private String providerId;// = new String("");
    private String packageId;// = new String("");
    private String placeName;// = new String("");
    private String postcode;// = new String("");
    private String rdfAbout;// = new String("");
    private String rights;// = new String("");

    public List<AgentInfo> getContributor() {
        return contributor;
    }

    public void setContributor(List<AgentInfo> contributor) {
        this.contributor = contributor;
    }



    public List<AatSubject> getAatSubjects() {
        return aatSubjects;
    }

    public void setAatSubjects(List<AatSubject> aatSubjects) {
        this.aatSubjects = aatSubjects;
    }

    public String getAccessPolicy() {
        return accessPolicy;
    }

    public void setAccessPolicy(String accessPolicy) {
        this.accessPolicy = accessPolicy;
    }

    public String getAccessRights() {
        return accessRights;
    }

    public void setAccessRights(String accessRights) {
        this.accessRights = accessRights;
    }

    public ArchaeologicalResourceType getArchaeologicalResourceType() {
        return archaeologicalResourceType;
    }

    public void setArchaeologicalResourceType(ArchaeologicalResourceType archaeologicalResourceType) {
        this.archaeologicalResourceType = archaeologicalResourceType;
    }

    public String getContactPoint() {
        return contactPoint;
    }

    public void setContactPoint(String contactPoint) {
        this.contactPoint = contactPoint;
    }

    public List<AgentInfo> getCreator() {
        return creator;
    }

    public void setCreator(List<AgentInfo> creator) {
        this.creator = creator;
    }

    public List<DerivedSubject> getDerivedSubject() {
        return derivedSubject;
    }

    public void setDerivedSubject(List<DerivedSubject> derivedSubject) {
        this.derivedSubject = derivedSubject;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Distribution> getDistribution() {
        return distribution;
    }

    public void setDistribution(List<Distribution> distribution) {
        this.distribution = distribution;
    }

    public List<AgentInfo> getPublisher() {
        return publisher;
    }

    public void setPublisher(List<AgentInfo> publisher) {
        this.publisher = publisher;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getExtent() {
        return extent;
    }

    public void setExtent(String extent) {
        this.extent = extent;
    }

    public List<ItemMetadataStructure> getHasItemMetadataStructure() {
        return hasItemMetadataStructure;
    }

    public void setHasItemMetadataStructure(List<ItemMetadataStructure> hasItemMetadataStructure) {
        this.hasItemMetadataStructure = hasItemMetadataStructure;
    }

    public List<MetadataRecord> getHasMetadataRecord() {
        return hasMetadataRecord;
    }

    public void setHasMetadataRecord(List<MetadataRecord> hasMetadataRecord) {
        this.hasMetadataRecord = hasMetadataRecord;
    }

    public String getIdentifier() {
        return identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public List<String> getIsPartOf() {
        return isPartOf;
    }

    public void setIsPartOf(List<String> isPartOf) {
        this.isPartOf = isPartOf;
    }

    public String getIssued() {
        return issued;
    }

    public void setIssued(String issued) {
        this.issued = ESUtils.getESFormatDate(issued);
    }

    public List<String> getKeyword() {
        return keyword;
    }

    public void setKeyword(List<String> keyword) {
        this.keyword = keyword;
    }

    public String getLandingPage() {
        return landingPage;
    }

    public void setLandingPage(String landingPage) {
        this.landingPage = landingPage;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        if (language!=null && language.equals("eng")) {
            this.language = "en";
        }
        else {
            this.language = language;
        }
    }

    public List<AgentInfo> getLegalResponsible() {
        return legalResponsible;
    }

    public void setLegalResponsible(List<AgentInfo> legalResponsible) {
        this.legalResponsible = legalResponsible;
    }

    public String getModified() {
        return modified;
    }

    public void setModified(String modified) {
        this.modified = ESUtils.getESFormatDate(modified);
    }

    public List<NativeSubject> getNativeSubject() {
        return nativeSubject;
    }

    public void setNativeSubject(List<NativeSubject> nativeSubject) {
        this.nativeSubject = nativeSubject;
    }

    public String getOriginalId() {
        return originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public List<AgentInfo> getOwner() {
        return owner;
    }

    public void setOwner(List<AgentInfo> owner) {
        this.owner = owner;
    }

    public String getPackageId() {
        return packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public String getPlaceName() {
        return placeName;
    }

    public void setPlaceName(String placeName) {
        this.placeName = placeName;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getRdfAbout() {
        return rdfAbout;
    }

    public void setRdfAbout(String rdfAbout) {
        this.rdfAbout = rdfAbout;
    }

    public String getResourceType() {
        return resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getRights() {
        return rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public List<AgentInfo> getScientificResponsible() {
        return scientificResponsible;
    }

    public void setScientificResponsible(List<AgentInfo> scientificResponsible) {
        this.scientificResponsible = scientificResponsible;
    }

    public List<Spatial> getSpatial() {
        return spatial;
    }

    public void setSpatial(List<Spatial> spatial) {
        if (this.spatial==null) {
            this.spatial = spatial;
        }
        else {
            this.spatial.addAll(spatial);
        }
    }

    public List<AgentInfo> getTechnicalResponsible() {
        return technicalResponsible;
    }

    public void setTechnicalResponsible(List<AgentInfo> technicalResponsible) {
        this.technicalResponsible = technicalResponsible;
    }

    public List<AriadneTemporal> getTemporal() {
        return temporal;
    }

    public void setTemporal(List<AriadneTemporal> temporal) {
        this.temporal = temporal;
    }

    public String getUniqueIsPartOf() {
        return uniqueIsPartOf;
    }

    public void setUniqueIsPartOf(String uniqueIsPartOf) {
        this.uniqueIsPartOf = uniqueIsPartOf;
    }

    public static AriadneCatalogEntry fromJson(String json){
        return new Gson().fromJson(json, AriadneCatalogEntry.class);
    }

    public  String toJson(){
        return new Gson().toJson(this);
    }

    public void setAccrualPeriodicity(String accrualPeriodicity) {
        this.accrualPeriodicity = accrualPeriodicity;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getRdfType() {
        return rdfType;
    }

    public void setRdfType(String rdfType) {
        this.rdfType = rdfType;
    }
}