/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.publisher;

import eu.dnetlib.ariadneplus.publisher.AriadnePlusPublisherException;
import eu.dnetlib.ariadneplus.publisher.AriadnePlusPublisherHelper;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AriadnePlusPublisherController {
    private static final Log log = LogFactory.getLog(AriadnePlusPublisherController.class);
    private static final String DEFAULT_TARGET_ENDPOINT = "GRAPHDB";
    @Autowired
    private AriadnePlusPublisherHelper ariadneplusPublisherHelper;

    @RequestMapping(value={"/version"}, method={RequestMethod.GET})
    public String version() throws AriadnePlusPublisherException {
        return "3.0.0-SNAPSHOT";
    }

    @RequestMapping(value={"/publish"}, method={RequestMethod.POST})
    public void publish(@RequestParam String record) throws AriadnePlusPublisherException {
        this.getAriadnePlusPublisherHelper().publish(record, this.getTarget(DEFAULT_TARGET_ENDPOINT));
    }

    @RequestMapping(value={"/feedProvenance"}, method={RequestMethod.POST})
    public void feedProvenance(@RequestParam String datasource, @RequestParam String datasourceApi) throws AriadnePlusPublisherException {
        this.getAriadnePlusPublisherHelper().feedProvenance(datasource, datasourceApi, this.getTarget(DEFAULT_TARGET_ENDPOINT));
    }

    @RequestMapping(value={"/dropDatasourceApiGraph"}, method={RequestMethod.POST})
    public void dropDatasourceApisPartitionInfo(@RequestParam String datasourceApi) throws AriadnePlusPublisherException {
        this.getAriadnePlusPublisherHelper().dropDatasourceApiGraph(datasourceApi, this.getTarget(DEFAULT_TARGET_ENDPOINT));
    }

    @RequestMapping(value={"/unpublish"}, method={RequestMethod.GET})
    public void unpublish(@RequestParam String datasourceApi) throws AriadnePlusPublisherException {
        this.getAriadnePlusPublisherHelper().unpublish(datasourceApi, this.getTarget(DEFAULT_TARGET_ENDPOINT));
    }

    private AriadnePlusPublisherHelper.AriadnePlusTargets getTarget(String value) {
        return AriadnePlusPublisherHelper.AriadnePlusTargets.valueOf((String)value);
    }

    public AriadnePlusPublisherHelper getAriadnePlusPublisherHelper() {
        return this.ariadneplusPublisherHelper;
    }

    public void setAriadnePlusPublisherHelper(AriadnePlusPublisherHelper ariadneplusPublisherHelper) {
        this.ariadneplusPublisherHelper = ariadneplusPublisherHelper;
    }

    @RequestMapping(value={"/updateSparql"}, method={RequestMethod.POST})
    public String updateSparql(@RequestBody String queryValue) throws AriadnePlusPublisherException {
        return this.getAriadnePlusPublisherHelper().updateSparql(queryValue, this.getTarget(DEFAULT_TARGET_ENDPOINT));
    }

    @RequestMapping(value={"/feedFromURL"}, method={RequestMethod.POST})
    public String feedFromURL(@RequestParam String dataUrl, @RequestParam String context) throws AriadnePlusPublisherException {
        return this.getAriadnePlusPublisherHelper().feedFromURL(dataUrl, context, this.getTarget(DEFAULT_TARGET_ENDPOINT));
    }

    @RequestMapping(value={"/indexOnES"}, method={RequestMethod.GET})
    public String indexOnES(@RequestParam String datasource, @RequestParam String collectionId) throws AriadnePlusPublisherException {
        return this.getAriadnePlusPublisherHelper().indexOnES(datasource, collectionId, this.getTarget(DEFAULT_TARGET_ENDPOINT));
    }

    @RequestMapping(value={"/selectIdentifiers"}, method={RequestMethod.GET})
    public List<String> selectIdentifiers(@RequestParam String datasource, @RequestParam String collectionId, @RequestParam String resourceType) throws AriadnePlusPublisherException {
        return this.getAriadnePlusPublisherHelper().selectIdentifiers(datasource, collectionId, resourceType, this.getTarget(DEFAULT_TARGET_ENDPOINT));
    }

    @RequestMapping(value={"/indexOnESByIdentifier"}, method={RequestMethod.POST})
    public String indexOnESByIdentifier(@RequestParam String datasource, @RequestParam String collectionId, @RequestParam String resourceType, @RequestParam String identifier) throws AriadnePlusPublisherException {
        return this.getAriadnePlusPublisherHelper().indexOnESByIdentifier(datasource, collectionId, resourceType, identifier, this.getTarget(DEFAULT_TARGET_ENDPOINT));
    }
}

