package eu.dnetlib.ariadneplus.elasticsearch.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;

import java.util.Map;

public class AgentInfo {
    private String email = new String("");
       private String name = new String("");
       private String phone = new String("");
       private String type = new String("");

    public AgentInfo() {

    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static AgentInfo fromJson(String json){
        return new Gson().fromJson(json, AgentInfo.class);
    }

    public static AgentInfo fromRDFJson(JsonElement json){
        AgentInfo pi = new AgentInfo();
        for (Map.Entry<String, JsonElement> entry : json.getAsJsonObject().entrySet()){
            switch (entry.getKey()){
                case "https://www.ariadne-infrastructure.eu/property/name" :
                    pi.setName(entry.getValue().getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString());
                    break;
                case "https://www.ariadne-infrastructure.eu/property/type":
                    pi.setType(entry.getValue().getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString());
                    break;
                case "https://www.ariadne-infrastructure.eu/property/email":
                    pi.setEmail(entry.getValue().getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString());
                    break;
                case "https://www.ariadne-infrastructure.eu/property/phone":
                    pi.setPhone(entry.getValue().getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString());
                    break;
            }
        }

        return pi;
    }
}
