package eu.dnetlib.ariadneplus.elasticsearch.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;

import java.util.HashMap;
import java.util.Map;

public class ArchaeologicalResourceType {
    private long id = -1;
    private String name;

    private transient HashMap<String, Long> type =new HashMap<>();

    public ArchaeologicalResourceType() {
        type.put("Site/monument", new Long(10));
        type.put("Fieldwork", new Long(11));
        type.put("Fieldwork report", new Long(12));
        type.put("Scientific analysis", new Long(13));
        type.put("Date", new Long(14));
        type.put("Artefact", new Long(15));
        type.put("Fieldwork archive", new Long(16));
        type.put("Inscription", new Long(17));
        type.put("Burial", new Long(18));
        type.put("Rock Art", new Long(19));
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.name==null) {
            setId(-1);
        }
        if (type.containsKey(this.name)) {
            setId(type.get(name).longValue());
        }
        else {
            setId(-2);
        }
    }

    public static ArchaeologicalResourceType fromJson(String json){
        return new Gson().fromJson(json, ArchaeologicalResourceType.class);
    }
}
