/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.reader;

import eu.dnetlib.ariadneplus.elasticsearch.BulkUpload;
import eu.dnetlib.ariadneplus.reader.ResourceManager;
import eu.dnetlib.ariadneplus.reader.json.ParseRDFJSON;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.http.HTTPQueryEvaluationException;
import org.eclipse.rdf4j.repository.manager.RemoteRepositoryManager;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RunSPARQLQueryService {
    private static final Log log = LogFactory.getLog(RunSPARQLQueryService.class);
    private RepositoryConnection connection;
    private RemoteRepositoryManager manager;
    private Repository repository;
    private ParseRDFJSON parser;
    private ResourceManager resourceManager;
    private BulkUpload bulkUpload;
    private static String username = null;
    private static String pwd = null;
    private static String graphDBUrl = null;
    private static String graphDBRepository = null;

    public void setupConnection(String username, String pwd, String graphDbUrl, String graphDbRepository) {
        RunSPARQLQueryService.setUsername((String)username);
        RunSPARQLQueryService.setPwd((String)pwd);
        RunSPARQLQueryService.setGraphDBUrl((String)graphDbUrl);
        RunSPARQLQueryService.setGraphDBRepository((String)graphDbRepository);
    }

    private void openConnection() {
        this.manager = new RemoteRepositoryManager(RunSPARQLQueryService.getGraphDBUrl());
        this.manager.init();
        this.manager.setUsernameAndPassword(RunSPARQLQueryService.getUsername(), RunSPARQLQueryService.getPwd());
        this.repository = this.manager.getRepository(RunSPARQLQueryService.getGraphDBRepository());
        this.connection = this.repository.getConnection();
    }

    private void closeConnection() {
        this.connection.close();
        this.repository.shutDown();
        this.manager.shutDown();
    }

    public String executeMultipleQueryGraph(String queryTemplate, List<String> recordIds, String datasource, String collectionId, boolean isCollection) {
        if (queryTemplate == null) {
            return null;
        }
        String selectQueryTemplate = queryTemplate.replaceAll("%datasource", datasource).replaceAll("%collectionId", collectionId);
        List<Integer> errorCodesCount = Arrays.asList(new Integer(0));
        List<Integer> successCodesCount = Arrays.asList(new Integer(0));
        List<Integer> counter = Arrays.asList(new Integer(0));
        recordIds.forEach(recordId -> {
            int currentSuccessCount;
            int waitAmount = 1;
            int retryResult = 0;
            int operationResult = this.executeQueryGraph(selectQueryTemplate, recordId, isCollection);
            if (operationResult != 200) {
                log.error((Object)(recordId + " error_code: " + operationResult));
                if (operationResult == -5) {
                    do {
                        try {
                            log.warn((Object)("Waiting more free space on heap for " + waitAmount + " seconds ..."));
                            Thread.sleep(waitAmount * 1000);
                            waitAmount *= 2;
                        }
                        catch (InterruptedException ie) {
                            log.error((Object)ie);
                        }
                        retryResult = this.executeQueryGraph(selectQueryTemplate, recordId, isCollection);
                        log.debug((Object)("retryResult: " + retryResult));
                    } while (retryResult != 200);
                    operationResult = retryResult;
                }
                if (operationResult != 200) {
                    int currentErrorsCount = (Integer)errorCodesCount.get(0);
                    errorCodesCount.set(0, new Integer(++currentErrorsCount));
                } else {
                    currentSuccessCount = (Integer)successCodesCount.get(0);
                    successCodesCount.set(0, new Integer(++currentSuccessCount));
                }
            } else {
                currentSuccessCount = (Integer)successCodesCount.get(0);
                successCodesCount.set(0, new Integer(++currentSuccessCount));
            }
            int counterValue = (Integer)counter.get(0);
            String curReport = null;
            if (counterValue > 0 && counterValue % 1000 == 0) {
                curReport = "Current analyzed records: " + counterValue + " Current indexed records: " + (Integer)successCodesCount.get(0) + " , Current errors: " + (Integer)errorCodesCount.get(0);
                log.info((Object)curReport);
            }
            counter.set(0, new Integer(++counterValue));
        });
        String report = "Total indexed records: " + successCodesCount.get(0) + " , Total errors: " + errorCodesCount.get(0);
        log.info((Object)report);
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeQueryGraph(String selectQueryTemplate, String recordId, boolean isCollection) {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String query = selectQueryTemplate.replaceAll("%record", "<" + recordId + ">");
        this.openConnection();
        StringWriter recordWriter = null;
        Model resultsModel = null;
        try {
            long start = System.currentTimeMillis();
            GraphQuery graphQuery = this.connection.prepareGraphQuery(QueryLanguage.SPARQL, query);
            GraphQueryResult graphQueryResult = graphQuery.evaluate();
            resultsModel = QueryResults.asModel((CloseableIteration)graphQueryResult);
            graphQueryResult.close();
            long end = System.currentTimeMillis();
            int triples = resultsModel.size();
            if (resultsModel.size() == 0) {
                int n = -2;
                return n;
            }
            recordWriter = new StringWriter();
            RDFWriter rdfRecordWriter = Rio.createWriter((RDFFormat)RDFFormat.RDFJSON, (Writer)recordWriter);
            Rio.write((Iterable)resultsModel, (RDFHandler)rdfRecordWriter);
            this.parser.setCollection(isCollection);
            String bufferedRecord = recordWriter.toString();
            int size = this.parser.parse(bufferedRecord);
            log.debug((Object)(recordId + " is_coll: " + isCollection + " query_time(sec): " + (end - start) / 1000L + " triples: " + triples + " json: " + size));
            if (size == -1) {
                int n = -4;
                return n;
            }
            this.resourceManager.manage(this.parser);
            int n = this.bulkUpload.index(this.resourceManager, isCollection);
            return n;
        }
        catch (HTTPQueryEvaluationException qe) {
            log.error((Object)qe);
            if (qe.getMessage() != null && qe.getMessage().contains("Insufficient free Heap Memory")) {
                int n = -5;
                return n;
            }
            int n = -6;
            return n;
        }
        catch (Exception e) {
            log.error((Object)e);
            int n = -1;
            return n;
        }
        finally {
            this.closeConnection();
            if (resultsModel != null) {
                resultsModel.clear();
            }
        }
    }

    public ParseRDFJSON getParser() {
        return this.parser;
    }

    public void setParser(ParseRDFJSON parser) {
        this.parser = parser;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public BulkUpload getBulkUpload() {
        return this.bulkUpload;
    }

    public void setBulkUpload(BulkUpload bulkUpload) {
        this.bulkUpload = bulkUpload;
    }

    public static String getUsername() {
        return username;
    }

    public static String getPwd() {
        return pwd;
    }

    public static String getGraphDBUrl() {
        return graphDBUrl;
    }

    public static String getGraphDBRepository() {
        return graphDBRepository;
    }

    public static void setUsername(String username) {
        RunSPARQLQueryService.username = username;
    }

    public static void setPwd(String pwd) {
        RunSPARQLQueryService.pwd = pwd;
    }

    public static void setGraphDBUrl(String graphDBUrl) {
        RunSPARQLQueryService.graphDBUrl = graphDBUrl;
    }

    public static void setGraphDBRepository(String graphDBRepository) {
        RunSPARQLQueryService.graphDBRepository = graphDBRepository;
    }

    public List<String> selectRecordIds(String datasource, String collectionId) {
        log.debug((Object)"Retrieving record Ids from GraphDB ...");
        String queryTemplate = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nselect * \nfrom  <https://ariadne-infrastructure.eu/api_________::ariadne_plus::%datasource::%collectionId>\nwhere { \n\t?recordId rdf:type <https://www.ariadne-infrastructure.eu/resource/ao/cat/1.1/AO_Individual_Data_Resource> .\n} \n";
        String query = queryTemplate.replaceAll("%datasource", datasource).replaceAll("%collectionId", collectionId);
        return this.executeSelect(query);
    }

    public List<String> selectCollectionIds(String datasource, String collectionId) {
        log.debug((Object)"Retrieving collection Ids from GraphDB ...");
        String queryTemplate = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nselect * \nfrom  <https://ariadne-infrastructure.eu/api_________::ariadne_plus::%datasource::%collectionId>\nwhere { \n\t?recordId rdf:type <https://www.ariadne-infrastructure.eu/resource/ao/cat/1.1/AO_Collection> .\n} \n";
        String query = queryTemplate.replaceAll("%datasource", datasource).replaceAll("%collectionId", collectionId);
        return this.executeSelect(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> executeSelect(String query) {
        this.openConnection();
        Object jsonRecord = null;
        ArrayList<String> results = new ArrayList<String>();
        try {
            TupleQuery selectQuery = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, query);
            TupleQueryResult selectQueryResult = selectQuery.evaluate();
            int counter = 0;
            while (selectQueryResult.hasNext()) {
                BindingSet recordSet = (BindingSet)selectQueryResult.next();
                Value recordIdValue = recordSet.getValue("recordId");
                results.add(recordIdValue.stringValue());
                ++counter;
            }
            log.debug((Object)("Total records retrieved: " + counter));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return results;
    }
}

