/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.publisher;

import eu.dnetlib.ariadneplus.graphdb.GraphDBClient;
import eu.dnetlib.ariadneplus.graphdb.GraphDBClientFactory;
import eu.dnetlib.ariadneplus.publisher.AriadnePlusPublisherException;
import eu.dnetlib.ariadneplus.publisher.AriadnePlusPublisherHelper;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AriadnePlusPublisherHelper {
    private static final Log log = LogFactory.getLog(AriadnePlusPublisherHelper.class);
    @Autowired
    private GraphDBClientFactory graphdbClientFactory;

    public void publish(String record, AriadnePlusTargets target) throws AriadnePlusPublisherException {
        switch (1.$SwitchMap$eu$dnetlib$ariadneplus$publisher$AriadnePlusPublisherHelper$AriadnePlusTargets[target.ordinal()]) {
            case 1: {
                this.publishGraphDB(record);
                break;
            }
            default: {
                throw new AriadnePlusPublisherException("Target " + target + " not supported yet");
            }
        }
    }

    public void feedProvenance(String datasource, String datasourceApi, AriadnePlusTargets target) throws AriadnePlusPublisherException {
        switch (1.$SwitchMap$eu$dnetlib$ariadneplus$publisher$AriadnePlusPublisherHelper$AriadnePlusTargets[target.ordinal()]) {
            case 1: {
                this.feedProvenance(datasource, datasourceApi);
                break;
            }
            default: {
                throw new AriadnePlusPublisherException("Target " + target + " not supported yet");
            }
        }
    }

    public void dropDatasourceApiGraph(String datasourceApi, AriadnePlusTargets target) throws AriadnePlusPublisherException {
        switch (1.$SwitchMap$eu$dnetlib$ariadneplus$publisher$AriadnePlusPublisherHelper$AriadnePlusTargets[target.ordinal()]) {
            case 1: {
                this.dropDatasourceApiGraph(datasourceApi);
                break;
            }
            default: {
                throw new AriadnePlusPublisherException("Target " + target + " not supported yet");
            }
        }
    }

    public long unpublish(String datasourceInterface, AriadnePlusTargets target) throws AriadnePlusPublisherException {
        long res = 0L;
        switch (1.$SwitchMap$eu$dnetlib$ariadneplus$publisher$AriadnePlusPublisherHelper$AriadnePlusTargets[target.ordinal()]) {
            case 1: {
                res = this.unpublishGraphDB(datasourceInterface);
                break;
            }
            default: {
                throw new AriadnePlusPublisherException("Target " + target + " not supported yet");
            }
        }
        return res;
    }

    public String updateSparql(String queryValue, AriadnePlusTargets target) throws AriadnePlusPublisherException {
        String res;
        switch (1.$SwitchMap$eu$dnetlib$ariadneplus$publisher$AriadnePlusPublisherHelper$AriadnePlusTargets[target.ordinal()]) {
            case 1: {
                res = this.updateSparqlGraphDB(queryValue);
                break;
            }
            default: {
                throw new AriadnePlusPublisherException("Target " + target + " not supported yet");
            }
        }
        return res;
    }

    public String feedFromURL(String dataUrl, String context, AriadnePlusTargets target) throws AriadnePlusPublisherException {
        String res;
        switch (1.$SwitchMap$eu$dnetlib$ariadneplus$publisher$AriadnePlusPublisherHelper$AriadnePlusTargets[target.ordinal()]) {
            case 1: {
                res = this.feedFromURL(dataUrl, context);
                break;
            }
            default: {
                throw new AriadnePlusPublisherException("Target " + target + " not supported yet");
            }
        }
        return res;
    }

    public String indexOnES(String datasource, String collectionId, AriadnePlusTargets target) throws AriadnePlusPublisherException {
        String res;
        switch (1.$SwitchMap$eu$dnetlib$ariadneplus$publisher$AriadnePlusPublisherHelper$AriadnePlusTargets[target.ordinal()]) {
            case 1: {
                res = this.indexOnES(datasource, collectionId);
                break;
            }
            default: {
                throw new AriadnePlusPublisherException("Target " + target + " not supported yet");
            }
        }
        return res;
    }

    private void publishGraphDB(String record) throws AriadnePlusPublisherException {
        GraphDBClient graphDBClient = this.graphdbClientFactory.getGraphDBClient();
        graphDBClient.feed(record);
    }

    private void feedProvenance(String datasource, String datasourceApi) throws AriadnePlusPublisherException {
        log.debug((Object)("Feed Provenance " + datasource + " - " + datasourceApi));
        GraphDBClient graphDBClient = this.graphdbClientFactory.getGraphDBClient();
        graphDBClient.feedProvenance(datasource, datasourceApi);
    }

    private void dropDatasourceApiGraph(String datasourceApi) throws AriadnePlusPublisherException {
        log.debug((Object)("Drop DatasourceApis Partition Info " + datasourceApi));
        GraphDBClient graphDBClient = this.graphdbClientFactory.getGraphDBClient();
        graphDBClient.dropDatasourceApiGraph(datasourceApi);
    }

    private long unpublishGraphDB(String datasourceInterface) {
        log.info((Object)("Unpublishing from graphdb " + datasourceInterface));
        GraphDBClient graphDBClient = this.graphdbClientFactory.getGraphDBClient();
        return 0L;
    }

    private String updateSparqlGraphDB(String queryValue) throws AriadnePlusPublisherException {
        log.info((Object)("updateSparqlGraphDB " + queryValue));
        GraphDBClient graphDBClient = this.graphdbClientFactory.getGraphDBClient();
        return graphDBClient.updateSparql(queryValue);
    }

    private String feedFromURL(String dataUrl, String context) throws AriadnePlusPublisherException {
        log.info((Object)("feedFromURL " + dataUrl + " " + context));
        GraphDBClient graphDBClient = this.graphdbClientFactory.getGraphDBClient();
        return graphDBClient.feedFromURL(dataUrl, context);
    }

    private String indexOnES(String datasource, String collectionId) throws AriadnePlusPublisherException {
        GraphDBClient graphDBClient = this.graphdbClientFactory.getGraphDBClient();
        return graphDBClient.indexOnES(datasource, collectionId);
    }

    public List<String> selectIdentifiers(String datasource, String collectionId, String resourceType, AriadnePlusTargets target) throws AriadnePlusPublisherException {
        GraphDBClient graphDBClient = this.graphdbClientFactory.getGraphDBClient();
        return graphDBClient.selectIdentifiers(datasource, collectionId, resourceType);
    }

    public String indexOnESByIdentifier(String datasource, String collectionId, String resourceType, String identifier, AriadnePlusTargets target) throws AriadnePlusPublisherException {
        GraphDBClient graphDBClient = this.graphdbClientFactory.getGraphDBClient();
        return graphDBClient.indexOnESByIdentifier(datasource, collectionId, resourceType, identifier);
    }
}

