/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.graphdb;

import eu.dnetlib.ariadneplus.graphdb.GraphDBClient;
import eu.dnetlib.ariadneplus.rdf.RecordParserHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GraphDBClientFactory {
    private static final Log log = LogFactory.getLog(GraphDBClientFactory.class);
    @Value(value="${graphdb.serverUrl}")
    private String graphDBServerUrl;
    @Value(value="${graphdb.baseURI}")
    private String graphDBBaseURI;
    @Value(value="${graphdb.writer.user}")
    private String writerUser;
    @Value(value="${graphdb.writer.pwd}")
    private String writerPwd;
    @Value(value="${graphdb.repository}")
    private String repository;
    @Autowired
    private RecordParserHelper recordParserHelper;
    @Autowired
    private GraphDBClient graphDBClient;

    public GraphDBClient getGraphDBClient() {
        this.graphDBClient.setup(this.recordParserHelper, this.graphDBServerUrl, this.graphDBBaseURI, this.writerUser, this.writerPwd, this.repository);
        return this.graphDBClient;
    }

    public RecordParserHelper getRecordParserHelper() {
        return this.recordParserHelper;
    }

    public void setRecordParserHelper(RecordParserHelper recordParserHelper) {
        this.recordParserHelper = recordParserHelper;
    }

    public String getGraphDBServerUrl() {
        return this.graphDBServerUrl;
    }

    public void setGraphDBServerUrl(String graphDBServerUrl) {
        this.graphDBServerUrl = graphDBServerUrl;
    }

    public String getGraphDBBaseURI() {
        return this.graphDBBaseURI;
    }

    public void setGraphDBBaseURI(String graphDBBaseURI) {
        this.graphDBBaseURI = graphDBBaseURI;
    }

    public String getWriterUser() {
        return this.writerUser;
    }

    public void setWriterUser(String writerUser) {
        this.writerUser = writerUser;
    }

    public String getWriterPwd() {
        return this.writerPwd;
    }

    public void setWriterPwd(String writerPwd) {
        this.writerPwd = writerPwd;
    }
}

