/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.reader.utils;

import java.time.LocalDate;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.util.Collections;
import java.util.Locale;

/*
 * Exception performing whole class analysis ignored.
 */
public class ESUtils {
    private static DateTimeFormatter originalRecordDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
    private static DateTimeFormatter elasticSearchDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static DateTimeFormatter fastCatDateFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static ZoneId preferredZone = ZoneId.of("Europe/London");
    private static DateTimeFormatter BST_FORMATTER = new DateTimeFormatterBuilder().appendPattern("EEE MMM dd HH:mm:ss ").appendZoneText(TextStyle.SHORT, Collections.singleton(preferredZone)).appendPattern(" yyyy").toFormatter(Locale.ROOT);
    private static DateTimeFormatter yearOnlyDateFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy").toFormatter();

    public static String getESFormatDate(String originalDate) {
        try {
            LocalDate parsedDate = LocalDate.parse(originalDate, elasticSearchDateFormatter);
            return parsedDate.format(elasticSearchDateFormatter);
        }
        catch (Exception e) {
            try {
                Year year = Year.parse(originalDate);
                return year.format(yearOnlyDateFormatter);
            }
            catch (Exception e0) {
                try {
                    LocalDate parsedDate = LocalDate.parse(originalDate, originalRecordDateFormatter);
                    return parsedDate.format(elasticSearchDateFormatter);
                }
                catch (Exception e1) {
                    try {
                        LocalDate parsedDate = LocalDate.parse(originalDate.substring(0, 10), elasticSearchDateFormatter);
                        return parsedDate.format(elasticSearchDateFormatter);
                    }
                    catch (Exception e2) {
                        try {
                            return ESUtils.parseBST((String)originalDate);
                        }
                        catch (Exception e3) {
                            try {
                                LocalDate parsedDate = LocalDate.parse(originalDate, fastCatDateFormatter);
                                return parsedDate.format(elasticSearchDateFormatter);
                            }
                            catch (Exception e4) {
                                return "0000";
                            }
                        }
                    }
                }
            }
        }
    }

    private static String parseBST(String BSTDate) {
        ZonedDateTime zd = ZonedDateTime.parse(BSTDate, BST_FORMATTER);
        return zd.format(elasticSearchDateFormatter);
    }

    public static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

