package eu.dnetlib.ariadneplus.reader.utils;

import com.github.sisyphsu.dateparser.DateParser;
import com.github.sisyphsu.dateparser.DateParserUtils;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDate;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.Locale;

public class ESUtils {
    private static String elasticSearchDateFormat = "yyyy-MM-dd";


    public static String getESFormatDate(String originalDate) {
            if (StringUtils.isBlank(originalDate)) {
                return null;
            }
            String inputDate = originalDate.trim();
            // the library completes with 01-01 if we hae only the year: we do not want that.
            if(inputDate.length() == 4 && StringUtils.isNumeric(inputDate)){
                return inputDate;
            }
            try {
                final LocalDate date = DateParserUtils
                        .parseDate(inputDate.trim())
                        .toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate();
                return DateTimeFormatter.ofPattern(elasticSearchDateFormat).format(date);
            } catch (DateTimeParseException e) {
                return null;
            }
    }


    public static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; i++) {
            String hex = Integer.toHexString(0xff & hash[i]);
            if(hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}
