/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.reader.utils;

import com.github.sisyphsu.dateparser.DateParserUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;

public class ESUtils {
    private static String elasticSearchDateFormat = "yyyy-MM-dd";

    public static String getESFormatDate(String originalDate) {
        if (StringUtils.isBlank((CharSequence)originalDate)) {
            return null;
        }
        String inputDate = originalDate.trim();
        if (inputDate.length() == 4 && StringUtils.isNumeric((CharSequence)inputDate)) {
            return inputDate;
        }
        try {
            LocalDate date = DateParserUtils.parseDate((String)inputDate.trim()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            return DateTimeFormatter.ofPattern(elasticSearchDateFormat).format(date);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

