/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.graphdb;

import com.google.common.base.Splitter;
import eu.dnetlib.ariadneplus.elasticsearch.BulkUpload;
import eu.dnetlib.ariadneplus.publisher.AriadnePlusPublisherException;
import eu.dnetlib.ariadneplus.rdf.RecordParserHelper;
import eu.dnetlib.ariadneplus.reader.ResourceManager;
import eu.dnetlib.ariadneplus.reader.RunSPARQLQueryService;
import eu.dnetlib.ariadneplus.reader.RunSPARQLWriteService;
import eu.dnetlib.ariadneplus.reader.json.ParseRDFJSON;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.manager.RemoteRepositoryManager;
import org.eclipse.rdf4j.repository.util.Repositories;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class GraphDBClient {
    private static final Log log = LogFactory.getLog(GraphDBClient.class);
    public static final String PROVENANCE_NS = "http://www.d-net.research-infrastructures.eu/provenance/";
    @Autowired
    private RunSPARQLQueryService runSPQRLQuery;
    @Autowired
    private RunSPARQLWriteService runSPQRLWrite;
    @Autowired
    private ParseRDFJSON parseRDFJSON;
    @Autowired
    private ResourceManager resourceManager;
    @Autowired
    private BulkUpload bulkUpload;
    private RecordParserHelper recordParserHelper;
    private String graphDBServerUrl;
    private String graphDBBaseURI;
    private String writerUser;
    private String writerPwd;
    private String repository;

    protected void setup(RecordParserHelper recordParserHelper, String graphDBServerUrl, String graphDBBaseURI, String writerUser, String writerPwd, String repository) {
        this.recordParserHelper = recordParserHelper;
        this.graphDBServerUrl = graphDBServerUrl;
        this.graphDBBaseURI = graphDBBaseURI;
        this.writerUser = writerUser;
        this.writerPwd = writerPwd;
        this.repository = repository;
    }

    public long feed(String record) throws AriadnePlusPublisherException {
        try {
            String objIdentifier = this.recordParserHelper.getObjIdentifier(record);
            if (StringUtils.isBlank((CharSequence)objIdentifier)) {
                log.warn((Object)"Got record with no objIdentifier -- skipping");
                return 0L;
            }
            RemoteRepositoryManager manager = new RemoteRepositoryManager(this.graphDBServerUrl);
            manager.init();
            manager.setUsernameAndPassword(this.getWriterUser(), this.getWriterPwd());
            Repository repository = manager.getRepository(this.getRepository());
            ValueFactory factory = repository.getValueFactory();
            String datasourceApi = this.recordParserHelper.getDatasourceApi(record);
            IRI graph = factory.createIRI(this.getGraphDBBaseURI(), datasourceApi);
            try (RepositoryConnection con = repository.getConnection();){
                con.begin();
                String recordURI = this.getRecordURI(objIdentifier, datasourceApi);
                con.add(IOUtils.toInputStream((String)this.getRDFBlock(record), (String)"UTF-8"), recordURI, RDFFormat.RDFXML, new Resource[]{graph});
                con.commit();
            }
            catch (RDF4JException e) {
                log.error((Object)"error adding statement ...", (Throwable)e);
            }
            repository.shutDown();
            manager.shutDown();
            return 1L;
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new AriadnePlusPublisherException(e);
        }
    }

    public long feedProvenance(String datasource, String datasourceApi) throws AriadnePlusPublisherException {
        try {
            RemoteRepositoryManager manager = new RemoteRepositoryManager(this.graphDBServerUrl);
            manager.init();
            manager.setUsernameAndPassword(this.getWriterUser(), this.getWriterPwd());
            Repository repository = manager.getRepository(this.getRepository());
            ValueFactory factory = repository.getValueFactory();
            IRI IS_API_OF = factory.createIRI(PROVENANCE_NS, "isApiOf");
            IRI INSERTED_IN_DATE = factory.createIRI(PROVENANCE_NS, "insertedInDate");
            IRI rApi = factory.createIRI(this.getGraphDBBaseURI(), datasourceApi);
            Statement stmApi = factory.createStatement((Resource)rApi, IS_API_OF, (Value)factory.createLiteral(datasource));
            LocalDateTime now = LocalDateTime.now();
            Statement stmInsertedDate = factory.createStatement((Resource)rApi, INSERTED_IN_DATE, (Value)factory.createLiteral(now.toString()));
            IRI datasourceApisGraph = factory.createIRI(this.getGraphDBBaseURI(), "datasourceApis");
            try (RepositoryConnection con = repository.getConnection();){
                con.begin();
                con.remove((Resource)rApi, INSERTED_IN_DATE, null, new Resource[]{datasourceApisGraph});
                con.add(stmApi, new Resource[]{datasourceApisGraph});
                con.add(stmInsertedDate, new Resource[]{datasourceApisGraph});
                con.commit();
                con.close();
            }
            catch (RDF4JException e) {
                log.error((Object)"error adding statement ...", (Throwable)e);
                throw new AriadnePlusPublisherException((Throwable)e);
            }
            repository.shutDown();
            manager.shutDown();
            return 200L;
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new AriadnePlusPublisherException(e);
        }
    }

    public long dropDatasourceApiGraph(String datasourceApi) throws AriadnePlusPublisherException {
        try {
            RemoteRepositoryManager manager = new RemoteRepositoryManager(this.graphDBServerUrl);
            manager.init();
            manager.setUsernameAndPassword(this.getWriterUser(), this.getWriterPwd());
            Repository repository = manager.getRepository(this.getRepository());
            if (repository == null) {
                throw new AriadnePlusPublisherException("GraphDB repository not found");
            }
            ValueFactory factory = repository.getValueFactory();
            IRI rApi = factory.createIRI(this.getGraphDBBaseURI(), datasourceApi);
            try (RepositoryConnection con = repository.getConnection();){
                log.debug((Object)("removing namedGraph: " + rApi));
                Repositories.consume((Repository)repository, conn -> conn.clear(new Resource[]{rApi}));
            }
            catch (RDF4JException e) {
                log.error((Object)"error removing datasourceApi partition info ", (Throwable)e);
                throw new AriadnePlusPublisherException((Throwable)e);
            }
            repository.shutDown();
            manager.shutDown();
            return 200L;
        }
        catch (Throwable e) {
            log.error((Object)"error removing datasourceApi partition info ", e);
            throw new AriadnePlusPublisherException(e);
        }
    }

    private String getRecordURI(String objIdentifier, String datasourceApi) {
        return "/" + datasourceApi + "/" + objIdentifier;
    }

    public RecordParserHelper getRecordParserHelper() {
        return this.recordParserHelper;
    }

    public void setRecordParserHelper(RecordParserHelper recordParserHelper) {
        this.recordParserHelper = recordParserHelper;
    }

    public void setDefaultBaseURI(String defaultBaseURI) {
        this.graphDBServerUrl = defaultBaseURI;
    }

    public String getRDFBlock(String record) throws SaxonApiException {
        this.recordParserHelper.init();
        try {
            if (StringUtils.isBlank((CharSequence)record)) {
                log.warn((Object)"Got empty record");
                return "";
            }
            String objIdentifier = this.recordParserHelper.getObjIdentifier(record);
            if (StringUtils.isBlank((CharSequence)objIdentifier)) {
                log.warn((Object)"Got record with no objIdentifier -- skipping");
                return "";
            }
            String rdfBlock = this.recordParserHelper.getRDF(record);
            if (StringUtils.isBlank((CharSequence)rdfBlock)) {
                log.warn((Object)("Missing rdf:RDF in record with objIdentifier " + objIdentifier));
            }
            return rdfBlock;
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw e;
        }
    }

    public String getGraphDBBaseURI() {
        return this.graphDBBaseURI;
    }

    public void setGraphDBBaseURI(String graphDBBaseURI) {
        this.graphDBBaseURI = graphDBBaseURI;
    }

    public String getWriterUser() {
        return this.writerUser;
    }

    public void setWriterUser(String writerUser) {
        this.writerUser = writerUser;
    }

    public String getWriterPwd() {
        return this.writerPwd;
    }

    public void setWriterPwd(String writerPwd) {
        this.writerPwd = writerPwd;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String updateSparql(String queryValue) throws AriadnePlusPublisherException {
        try {
            String result = "";
            RemoteRepositoryManager manager = new RemoteRepositoryManager(this.graphDBServerUrl);
            manager.init();
            manager.setUsernameAndPassword(this.getWriterUser(), this.getWriterPwd());
            Repository repository = manager.getRepository(this.getRepository());
            try (RepositoryConnection con = repository.getConnection();){
                int countQueries = 0;
                int countSuccess = 0;
                for (String query : Splitter.on((String)";").split((CharSequence)queryValue)) {
                    ++countQueries;
                    con.begin();
                    Update updateResultQuery = con.prepareUpdate(queryValue);
                    if (updateResultQuery == null) {
                        throw new AriadnePlusPublisherException(String.format("Cannot generate Update statement from %s", query));
                    }
                    updateResultQuery.execute();
                    log.debug((Object)String.format("Query %d executed: %s", countQueries, query));
                    con.commit();
                    ++countSuccess;
                    log.debug((Object)String.format("Query %d committed", countQueries));
                }
                log.info((Object)String.format("Queries committed with success %d/%d", countSuccess, countQueries));
            }
            catch (RDF4JException e) {
                log.error((Object)"error executing query ...", (Throwable)e);
                throw new AriadnePlusPublisherException((Throwable)e);
            }
            repository.shutDown();
            manager.shutDown();
            return result;
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new AriadnePlusPublisherException(e);
        }
    }

    public String feedFromURL(String dataUrl, String context) throws AriadnePlusPublisherException {
        String result = "";
        RemoteRepositoryManager manager = new RemoteRepositoryManager(this.graphDBServerUrl);
        manager.init();
        manager.setUsernameAndPassword(this.getWriterUser(), this.getWriterPwd());
        Repository repository = manager.getRepository(this.getRepository());
        ValueFactory factory = repository.getValueFactory();
        try {
            RepositoryConnection con = repository.getConnection();
            con.begin();
            IRI contextIRI = factory.createIRI(this.getGraphDBBaseURI(), context);
            log.debug((Object)("adding data from: " + dataUrl + " to context: " + contextIRI.toString()));
            con.add(new URL(dataUrl), null, RDFFormat.TURTLE, new Resource[]{contextIRI});
            result.concat("data added from url: " + dataUrl + " into graph " + context);
            con.commit();
            log.debug((Object)"add data from Url executed");
        }
        catch (MalformedURLException | RDF4JException e) {
            throw new AriadnePlusPublisherException(e);
        }
        catch (IOException e) {
            throw new AriadnePlusPublisherException((Throwable)e);
        }
        finally {
            try {
                repository.shutDown();
                manager.shutDown();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public RunSPARQLQueryService getRunSPQRLQuery() {
        return this.runSPQRLQuery;
    }

    public void setRunSPQRLQuery(RunSPARQLQueryService runSPQRLQuery) {
        this.runSPQRLQuery = runSPQRLQuery;
    }

    public String indexOnES(String datasource, String collectionId) throws AriadnePlusPublisherException {
        String recordsIndexReport = "";
        String collectionIndexReport = "";
        try {
            log.debug((Object)("Start indexing from " + datasource + " " + collectionId));
            this.runSPQRLQuery.setupConnection(this.getWriterUser(), this.getWriterPwd(), this.graphDBServerUrl, this.getRepository());
            this.runSPQRLQuery.setParser(this.parseRDFJSON);
            this.runSPQRLQuery.setResourceManager(this.resourceManager);
            this.runSPQRLQuery.setBulkUpload(this.bulkUpload);
            List collectionResourceIds = this.runSPQRLQuery.selectCollectionIds(datasource, collectionId);
            log.info((Object)String.format("Found %d collections to index for datasource %s - %s", collectionResourceIds.size(), datasource, collectionId));
            try {
                if (!collectionResourceIds.isEmpty()) {
                    ClassPathResource selectCollectionTemplateRes = new ClassPathResource("eu/dnetlib/ariadneplus/sparql/read_collection_data_template.sparql");
                    String selectCollectionTemplate = IOUtils.toString((InputStream)selectCollectionTemplateRes.getInputStream(), (String)StandardCharsets.UTF_8.name());
                    collectionIndexReport = this.runSPQRLQuery.executeMultipleQueryGraph(selectCollectionTemplate, collectionResourceIds, datasource, collectionId, true);
                }
            }
            catch (RuntimeException re) {
                throw new AriadnePlusPublisherException((Throwable)re);
            }
            List recordIds = this.runSPQRLQuery.selectRecordIds(datasource, collectionId);
            log.info((Object)String.format("Found %d individual resources to index for datasource %s - %s", recordIds.size(), datasource, collectionId));
            if (!recordIds.isEmpty()) {
                ClassPathResource queryTemplateResource = new ClassPathResource("eu/dnetlib/ariadneplus/sparql/read_record_data_template.sparql");
                String queryTemplate = IOUtils.toString((InputStream)queryTemplateResource.getInputStream(), (String)StandardCharsets.UTF_8.name());
                recordsIndexReport = this.runSPQRLQuery.executeMultipleQueryGraph(queryTemplate, recordIds, datasource, collectionId, false);
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new AriadnePlusPublisherException(e);
        }
        return "Records: ".concat(recordsIndexReport).concat(" Collection: ").concat(collectionIndexReport);
    }

    public List<String> selectIdentifiers(String datasource, String collectionId, String resourceType) throws AriadnePlusPublisherException {
        List identifiers = Collections.emptyList();
        try {
            log.info((Object)("Select " + resourceType + " Identifiers from " + datasource + " " + collectionId));
            this.runSPQRLQuery.setupConnection(this.getWriterUser(), this.getWriterPwd(), this.graphDBServerUrl, this.getRepository());
            if (resourceType.equals("COLLECTION")) {
                identifiers = this.runSPQRLQuery.selectCollectionIds(datasource, collectionId);
                log.info((Object)String.format("Found %d collections for datasource %s - %s", identifiers.size(), datasource, collectionId));
            } else if (resourceType.equals("RECORD")) {
                identifiers = this.runSPQRLQuery.selectRecordIds(datasource, collectionId);
                log.info((Object)String.format("Found %d records for datasource %s - %s", identifiers.size(), datasource, collectionId));
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new AriadnePlusPublisherException(e);
        }
        return identifiers;
    }

    public String indexOnESByIdentifier(String datasource, String collectionId, String resourceType, String identifier) throws AriadnePlusPublisherException {
        String report = "";
        try {
            if (StringUtils.isBlank((CharSequence)identifier)) {
                return "empty identifier";
            }
            List<String> identifiers = Arrays.asList(identifier);
            log.info((Object)("Indexing " + datasource + " " + collectionId + " " + identifier));
            this.runSPQRLQuery.setupConnection(this.getWriterUser(), this.getWriterPwd(), this.graphDBServerUrl, this.getRepository());
            this.runSPQRLQuery.setParser(this.parseRDFJSON);
            this.runSPQRLQuery.setResourceManager(this.resourceManager);
            this.runSPQRLQuery.setBulkUpload(this.bulkUpload);
            if (resourceType.equals("COLLECTION")) {
                if (!identifiers.isEmpty()) {
                    ClassPathResource selectCollectionTemplateRes = new ClassPathResource("eu/dnetlib/ariadneplus/sparql/read_collection_data_template.sparql");
                    String selectCollectionTemplate = IOUtils.toString((InputStream)selectCollectionTemplateRes.getInputStream(), (String)StandardCharsets.UTF_8.name());
                    report = this.runSPQRLQuery.executeMultipleQueryGraph(selectCollectionTemplate, identifiers, datasource, collectionId, true);
                }
            } else if (resourceType.equals("RECORD") && !identifiers.isEmpty()) {
                ClassPathResource queryTemplateResource = new ClassPathResource("eu/dnetlib/ariadneplus/sparql/read_record_data_template.sparql");
                String queryTemplate = IOUtils.toString((InputStream)queryTemplateResource.getInputStream(), (String)StandardCharsets.UTF_8.name());
                report = this.runSPQRLQuery.executeMultipleQueryGraph(queryTemplate, identifiers, datasource, collectionId, false);
            }
        }
        catch (IOException | RuntimeException re) {
            throw new AriadnePlusPublisherException((Throwable)re);
        }
        return "Resources: ".concat(report);
    }

    public RunSPARQLWriteService getRunSPQRLWrite() {
        return this.runSPQRLWrite;
    }

    public void setRunSPQRLWrite(RunSPARQLWriteService runSPQRLWrite) {
        this.runSPQRLWrite = runSPQRLWrite;
    }

    public long callFeedService(String record) throws AriadnePlusPublisherException {
        try {
            String objIdentifier = this.recordParserHelper.getObjIdentifier(record);
            if (StringUtils.isBlank((CharSequence)objIdentifier)) {
                log.warn((Object)"Got record with no objIdentifier -- skipping");
                return 0L;
            }
            String datasourceApi = this.recordParserHelper.getDatasourceApi(record);
            String recordURI = this.getRecordURI(objIdentifier, datasourceApi);
            this.runSPQRLWrite.setupConnection(this.getWriterUser(), this.getWriterPwd(), this.graphDBServerUrl, this.getRepository());
            return this.runSPQRLWrite.writeRecord(IOUtils.toInputStream((String)this.getRDFBlock(record), (String)"UTF-8"), recordURI, datasourceApi, this.getGraphDBBaseURI());
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new AriadnePlusPublisherException(e);
        }
    }
}

