/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.reader;

import com.google.gson.Gson;
import eu.dnetlib.ariadneplus.reader.json.ParseRDFJSON;
import eu.dnetlib.ariadneplus.reader.utils.ClassSpec;
import eu.dnetlib.ariadneplus.reader.utils.Mappings;
import eu.dnetlib.ariadneplus.reader.utils.PropertiesMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ResourceManager {
    private static final Log log = LogFactory.getLog(ResourceManager.class);
    @Value(value="${type.path:undefined}")
    private String type_path;
    @Value(value="${general.classpath:undefined}")
    private String general_classpath;
    @Value(value="${exclude.predicates:[]}")
    private String exclude_predicates;
    @Value(value="${class.map.specifications:undefined}")
    private String spec;
    private List<String> not_parsable;
    private ParseRDFJSON parser;
    private PropertiesMap propertiesMap;

    public void setup(String type_path, String general_classpath, String exclude_predicates, String spec) {
        this.type_path = type_path;
        this.general_classpath = general_classpath;
        this.exclude_predicates = exclude_predicates;
        this.spec = spec;
        this.init();
    }

    @PostConstruct
    public void init() {
        Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.not_parsable = (List)new Gson().fromJson(this.exclude_predicates, listType);
        this.propertiesMap = new PropertiesMap();
        this.propertiesMap.fill(this.spec);
    }

    private String getFieldValue(Object value) {
        if (value instanceof LinkedHashMap) {
            return (String)((LinkedHashMap)value).get("value");
        }
        return (String)((JSONObject)value).get((Object)"value");
    }

    public void manage(ParseRDFJSON parser) {
        this.parser = parser;
    }

    public boolean hasNext() {
        return this.parser.hasNextElement();
    }

    public Object next() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.manage((Object)this.parser.getNextElement(), null);
    }

    private Object manage(Object entry, String class_name) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        LinkedHashMap tmp;
        if (class_name == null && entry instanceof LinkedHashMap && ((class_name = (String)(tmp = (LinkedHashMap)((JSONArray)((LinkedHashMap)entry).get(this.type_path)).get(0)).get("value")).equals("Record") || class_name.equals("Collection"))) {
            class_name = "AriadnePlusEntry";
        }
        if (entry == null) {
            return null;
        }
        Class<?> c = Class.forName(this.general_classpath + class_name);
        Object class_instance = c.newInstance();
        ClassSpec class_spec = this.propertiesMap.get(class_name);
        Set keySet = entry instanceof LinkedHashMap ? ((LinkedHashMap)entry).keySet() : ((JSONObject)entry).keySet();
        for (Object predicate : keySet) {
            Method setField;
            Mappings map;
            if (this.not_parsable.contains(predicate) || (map = class_spec.get((String)predicate)) == null) continue;
            JSONArray values = entry instanceof LinkedHashMap ? (JSONArray)((LinkedHashMap)entry).get(predicate) : (JSONArray)((JSONObject)entry).get(predicate);
            if (!map.hasExternalReference()) {
                Method setField2 = c.getMethod("set" + map.getClass_field(), Class.forName(map.getElement_type()));
                if (map.getClass_field().equals("Description")) {
                    setField2.invoke(class_instance, values.stream().map(value -> this.getFieldValue(value)).collect(Collectors.joining(" \n")));
                    continue;
                }
                if (map.getClass_field().equals("OtherId") || map.getClass_field().equals("IsPartOf")) {
                    for (Object v : values) {
                        setField2.invoke(class_instance, this.getFieldValue(v));
                    }
                    continue;
                }
                setField2.invoke(class_instance, this.getFieldValue(values.get(0)));
                continue;
            }
            if (this.propertiesMap.get(map.getExternal_reference()).getClass_type().equals("prototype")) {
                ArrayList<Object> value_list = new ArrayList<Object>();
                for (Object value2 : values) {
                    value_list.add(this.manage((Object)ParseRDFJSON.get((String)this.getFieldValue(value2)), map.getExternal_reference()));
                }
                setField = c.getMethod("set" + map.getClass_field(), List.class);
                setField.invoke(class_instance, value_list);
                continue;
            }
            Class<?> ref = Class.forName(this.general_classpath + map.getExternal_reference());
            setField = c.getMethod("set" + map.getClass_field(), ref);
            setField.invoke(class_instance, this.manage((Object)ParseRDFJSON.get((String)this.getFieldValue(values.get(0))), map.getExternal_reference()));
        }
        return class_instance;
    }

    public String getType_path() {
        return this.type_path;
    }

    public void setType_path(String type_path) {
        this.type_path = type_path;
    }

    public String getGeneral_classpath() {
        return this.general_classpath;
    }

    public void setGeneral_classpath(String general_classpath) {
        this.general_classpath = general_classpath;
    }

    public String getExclude_predicates() {
        return this.exclude_predicates;
    }

    public void setExclude_predicates(String exclude_predicates) {
        this.exclude_predicates = exclude_predicates;
    }

    public String getSpec() {
        return this.spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
}

