/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.reader;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.manager.RemoteRepositoryManager;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RunSPARQLWriteService {
    private static final Log log = LogFactory.getLog(RunSPARQLWriteService.class);
    private RemoteRepositoryManager manager;
    private Repository repository;
    private ValueFactory valueFactory;
    private static String username = null;
    private static String pwd = null;
    private static String graphDBUrl = null;
    private static String graphDBRepository = null;

    @PreDestroy
    public void preDestroy() {
        this.shutDownRepository();
    }

    public void setupConnection(String username, String pwd, String graphDbUrl, String graphDbRepository) {
        RunSPARQLWriteService.setUsername((String)username);
        RunSPARQLWriteService.setPwd((String)pwd);
        RunSPARQLWriteService.setGraphDBUrl((String)graphDbUrl);
        RunSPARQLWriteService.setGraphDBRepository((String)graphDbRepository);
        this.initRepository();
    }

    private void initRepository() {
        if (this.manager == null) {
            this.manager = new RemoteRepositoryManager(RunSPARQLWriteService.getGraphDBUrl());
            this.manager.init();
            this.manager.setUsernameAndPassword(RunSPARQLWriteService.getUsername(), RunSPARQLWriteService.getPwd());
            this.repository = this.manager.getRepository(RunSPARQLWriteService.getGraphDBRepository());
            this.valueFactory = this.repository.getValueFactory();
        }
    }

    private void shutDownRepository() {
        if (this.repository != null) {
            this.repository.shutDown();
        }
        if (this.manager != null) {
            this.manager.shutDown();
        }
    }

    public static String getUsername() {
        return username;
    }

    public static String getPwd() {
        return pwd;
    }

    public static String getGraphDBUrl() {
        return graphDBUrl;
    }

    public static String getGraphDBRepository() {
        return graphDBRepository;
    }

    public static void setUsername(String username) {
        RunSPARQLWriteService.username = username;
    }

    public static void setPwd(String pwd) {
        RunSPARQLWriteService.pwd = pwd;
    }

    public static void setGraphDBUrl(String graphDBUrl) {
        RunSPARQLWriteService.graphDBUrl = graphDBUrl;
    }

    public static void setGraphDBRepository(String graphDBRepository) {
        RunSPARQLWriteService.graphDBRepository = graphDBRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeRecord(InputStream rdfxmlRecord, String recordURI, String datasourceApi, String graphDBBaseURI) {
        RepositoryConnection connection = this.repository.getConnection();
        try {
            connection.add(rdfxmlRecord, recordURI, RDFFormat.RDFXML, new Resource[]{this.valueFactory.createIRI(graphDBBaseURI, datasourceApi)});
        }
        catch (Exception e) {
            log.error((Object)String.format("Exception processing result with URI %s:\n%s", recordURI, e));
            long l = -1L;
            return l;
        }
        finally {
            if (connection != null && connection.isOpen()) {
                connection.close();
            }
            try {
                rdfxmlRecord.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        return 0L;
    }
}

