/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.reader.json;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ParseRDFJSON {
    private static final Log log = LogFactory.getLog(ParseRDFJSON.class);
    static JSONObject map;
    @Value(value="${catalog.entry.path}")
    private String catalogEntryJsonPath;
    @Value(value="${catalog.entry.collection.path}")
    private String catalogEntryCollectionJsonPath;
    private boolean isCollection = false;
    private String json;
    private Iterator<Object> it;

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) throws ParseException {
        this.json = json;
    }

    private void fillMap() throws ParseException {
        map = (JSONObject)new JSONParser(-1).parse(this.json);
    }

    public int parse(String json) throws ParseException {
        this.setJson(json);
        this.fillMap();
        DocumentContext jsonContext = JsonPath.parse((String)json);
        JSONArray entries = (JSONArray)jsonContext.read(this.getCatalogEntryJsonPath(), new Predicate[0]);
        int size = entries.size();
        if (size == 0) {
            return -1;
        }
        this.it = entries.iterator();
        return size;
    }

    public boolean hasNextElement() {
        if (this.it == null) {
            return false;
        }
        return this.it.hasNext();
    }

    public LinkedHashMap getNextElement() {
        return (LinkedHashMap)this.it.next();
    }

    public static JSONObject get(String key) {
        return (JSONObject)map.get((Object)key);
    }

    public String getCatalogEntryJsonPath() {
        if (this.isCollection) {
            return this.catalogEntryCollectionJsonPath;
        }
        return this.catalogEntryJsonPath;
    }

    public void setCatalogEntryJsonPath(String catalogEntryJsonPath) {
        this.catalogEntryJsonPath = catalogEntryJsonPath;
    }

    public void setCatalogEntryCollectionJsonPath(String catalogEntryCollectionJsonPath) {
        this.catalogEntryCollectionJsonPath = catalogEntryCollectionJsonPath;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public void setCollection(boolean collection) {
        this.isCollection = collection;
    }
}

