package eu.dnetlib.ariadneplus.elasticsearch.model;

import com.google.gson.Gson;

/**
 * This class maps AO_Digital_Media, which can be rendered on the portal with the proper service based on the property 'type'.
 * One resource can have 0-N digital media.
 * One resource can have 0-1 primary digital media.
 * @author alessia.bardi
 */
public class DigitalMedia {

    /**
     * Label of the service that can render the media.
     */
    private String type;
    /**
     * Url of the digital media to be rendered. It is the rdfs:label of the media, not its resource URI.
     */
    private String url;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DigitalMedia() {
    }

    public static DigitalMedia fromJson(String json){
        return new Gson().fromJson(json, DigitalMedia.class);
    }
}
