/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.catalogue;

import com.google.common.collect.Lists;
import eu.dnetlib.ariadneplus.catalogue.CatalogueAPIResponse;
import eu.dnetlib.ariadneplus.jrr.AriadnePlusRegistryResource;
import eu.dnetlib.ariadneplus.publisher.AriadnePlusPublisherException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CatalogueAPIClient {
    private static final Log log = LogFactory.getLog(CatalogueAPIClient.class);
    @Value(value="${gcube.catalogue.baseurl}")
    private String baseURL;
    private final String itemPath = "items/";
    @Value(value="${gcube.registry.application.token}")
    private String applicationToken;
    @Value(value="${gcube.uri.resolver}")
    private String uriResolver;
    private String resolverBodyTemplate = "{ \"entity_name\": \"%s\" }";
    private String purgeBodyTemplate = "{\"id\":\"%s\"}";
    private HttpHeaders headersForResolver = new HttpHeaders();
    private HttpHeaders headersForCatalogue;
    @Autowired
    private RestTemplate restTemplate;

    public CatalogueAPIClient() {
        this.headersForResolver.setContentType(MediaType.APPLICATION_JSON);
        this.headersForCatalogue = new HttpHeaders();
        this.headersForCatalogue.setContentType(MediaType.APPLICATION_JSON);
        this.headersForCatalogue.setAccept((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.APPLICATION_JSON}));
        this.headersForCatalogue.set("gcube-token", this.getApplicationToken());
    }

    public String getNameForCatalogue(String resName) throws URISyntaxException {
        log.debug((Object)("Calling AriadnePlus resolver for " + resName));
        String body = String.format(this.resolverBodyTemplate, resName);
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)this.headersForResolver);
        URI uri = new URIBuilder(this.getUriResolver()).build();
        log.debug((Object)("Resolver at " + this.getUriResolver() + " post body:\n" + body));
        ResponseEntity res = this.restTemplate.exchange(uri, HttpMethod.POST, entity, String.class);
        if (res.getStatusCode().is2xxSuccessful()) {
            String resolved = (String)res.getBody();
            log.debug((Object)String.format("AriadnePlus resolver resolved %s with %s", resName, resolved));
            return resolved;
        }
        log.debug((Object)String.format("AriadnePlus resolver returned %s with cause %s for %s", res.getStatusCodeValue(), res.getStatusCode().getReasonPhrase(), resName));
        return null;
    }

    protected boolean isRegistered(String resCatName) throws AriadnePlusPublisherException {
        log.debug((Object)String.format("Catalogue --> Checking if item %s exists", resCatName));
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headersForCatalogue);
        try {
            URI uri = new URIBuilder(this.getBaseURL() + "items/").build();
            ResponseEntity response = this.restTemplate.exchange(uri + "/" + resCatName, HttpMethod.GET, entity, String.class, new Object[0]);
            return response.getStatusCode().is2xxSuccessful();
        }
        catch (Throwable t) {
            throw new AriadnePlusPublisherException(t);
        }
    }

    @Deprecated
    public AriadnePlusRegistryResource getRegistered(String resCatName) throws AriadnePlusPublisherException {
        log.debug((Object)String.format("Catalogue --> Checking if item %s exists", resCatName));
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headersForCatalogue);
        try {
            URI uri = new URIBuilder(this.getBaseURL() + "items/").build();
            ResponseEntity response = this.restTemplate.exchange(uri + "/" + resCatName, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                CatalogueAPIResponse body = new CatalogueAPIResponse();
                body.setResponseBody((String)response.getBody());
                AriadnePlusRegistryResource r = body.getAriadnePlusRegistryResource();
                log.debug((Object)String.format("Resource %s is in the catalogue with uuid %s", resCatName, r.getUuid()));
                return r;
            }
            log.debug((Object)String.format("Resource %s is not in the catalogue yet", resCatName));
            return null;
        }
        catch (Throwable t) {
            throw new AriadnePlusPublisherException(t);
        }
    }

    public boolean doRegister(String json, String resCatName) throws URISyntaxException, IOException {
        log.debug((Object)String.format("Catalogue --> Registering item %s : %s", resCatName, json));
        return this.doCatalogueCall(json, resCatName, HttpMethod.POST);
    }

    public boolean doUpdate(String json, String resCatName) throws IOException, URISyntaxException {
        log.debug((Object)String.format("Catalogue --> Updating item %s : %s", resCatName, json));
        return this.doCatalogueCall(json, resCatName, HttpMethod.PUT);
    }

    protected boolean doCatalogueCall(String json, String resCatName, HttpMethod method) throws URISyntaxException, IOException {
        HttpEntity entity = new HttpEntity((Object)json, (MultiValueMap)this.headersForCatalogue);
        URI uri = new URIBuilder(this.getBaseURL() + "items/").build();
        ResponseEntity res = this.restTemplate.exchange(uri, method, entity, String.class);
        if (res.getStatusCode().is2xxSuccessful()) {
            return true;
        }
        log.error((Object)String.format("Method %s on resource %s failed with code %s, reason: %s", method.name(), resCatName, res.getStatusCodeValue(), res.getBody()));
        return false;
    }

    protected boolean purgeItem(String resCatName) throws URISyntaxException, AriadnePlusPublisherException {
        log.debug((Object)String.format("Catalogue --> Purge Item %s", resCatName));
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headersForCatalogue);
        try {
            URI uri = new URIBuilder(this.getBaseURL() + "items/").build();
            ResponseEntity res = this.restTemplate.exchange(uri + "/" + resCatName + "?purge=true", HttpMethod.DELETE, entity, String.class, new Object[0]);
            if (res.getStatusCode().is2xxSuccessful()) {
                return true;
            }
            log.error((Object)String.format("Cannot purge item %s. HTTP error code %s, reason: %s", resCatName, res.getStatusCodeValue(), res.getBody()));
            return false;
        }
        catch (Throwable t) {
            throw new AriadnePlusPublisherException(t);
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getApplicationToken() {
        return this.applicationToken;
    }

    public void setApplicationToken(String applicationToken) {
        this.applicationToken = applicationToken;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(String uri_resolver) {
        this.uriResolver = this.uriResolver;
    }

    public String getPurgeBodyTemplate() {
        return this.purgeBodyTemplate;
    }

    public void setPurgeBodyTemplate(String purgeBodyTemplate) {
        this.purgeBodyTemplate = purgeBodyTemplate;
    }
}

