/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.publisher;

import eu.dnetlib.ariadneplus.jrr.JRRPublisher;
import eu.dnetlib.ariadneplus.publisher.AriadnePlusPublisherException;
import eu.dnetlib.ariadneplus.publisher.AriadnePlusPublisherHelper;
import eu.dnetlib.ariadneplus.virtuoso.VirtuosoClient;
import eu.dnetlib.ariadneplus.virtuoso.VirtuosoClientFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AriadnePlusPublisherHelper {
    private static final Log log = LogFactory.getLog(AriadnePlusPublisherHelper.class);
    @Autowired
    private VirtuosoClientFactory virtuosoClientFactory;
    @Autowired
    private JRRPublisher jrrPublisher;

    public void publish(String record, AriadnePlusTargets target) throws AriadnePlusPublisherException {
        switch (1.$SwitchMap$eu$dnetlib$ariadneplus$publisher$AriadnePlusPublisherHelper$AriadnePlusTargets[target.ordinal()]) {
            case 1: {
                this.publishVirtuoso(record);
                break;
            }
            case 2: {
                try {
                    this.publishJRR(record);
                    break;
                }
                catch (IOException | InterruptedException | URISyntaxException e) {
                    throw new AriadnePlusPublisherException((Throwable)e);
                }
            }
            default: {
                throw new AriadnePlusPublisherException("Target " + target + " not supported yet");
            }
        }
    }

    public long unpublish(String datasourceInterface, AriadnePlusTargets target) throws AriadnePlusPublisherException {
        long res = 0L;
        switch (1.$SwitchMap$eu$dnetlib$ariadneplus$publisher$AriadnePlusPublisherHelper$AriadnePlusTargets[target.ordinal()]) {
            case 1: {
                res = this.unpublishVirtuoso(datasourceInterface);
                break;
            }
            default: {
                throw new AriadnePlusPublisherException("Target " + target + " not supported yet");
            }
        }
        return res;
    }

    private void publishVirtuoso(String record) throws AriadnePlusPublisherException {
        log.debug((Object)"Publishing on virtuoso");
        VirtuosoClient virtuosoClient = this.virtuosoClientFactory.getVirtuosoClient();
        virtuosoClient.feed(record);
    }

    private void publishJRR(String record) throws AriadnePlusPublisherException, IOException, URISyntaxException, InterruptedException {
        log.debug((Object)"Publishing on JRR (registry and catalogue)");
        this.jrrPublisher.register(record);
    }

    private int unpublishJRR(String datasourceInterface) {
        log.debug((Object)("Unpublishing from registry " + datasourceInterface));
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private long unpublishVirtuoso(String datasourceInterface) {
        log.info((Object)("Unpublishing from virtuoso " + datasourceInterface));
        VirtuosoClient virtuosoClient = this.virtuosoClientFactory.getVirtuosoClient();
        long deletedTriples = virtuosoClient.drop(datasourceInterface);
        log.info((Object)("# triples deleted for " + datasourceInterface + ": " + deletedTriples));
        return deletedTriples;
    }

    public void dropRegistry() {
        log.debug((Object)"Dropping JRR");
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

