package eu.dnetlib.ariadneplus.publisher;

import eu.dnetlib.ariadneplus.publisher.AriadnePlusPublisherHelper.AriadnePlusTargets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AriadnePlusPublisherController {

	private static final Log log = LogFactory.getLog(AriadnePlusPublisherController.class);
	//TODO: to nicely handle arrors, follow https://docs.spring.io/spring-boot/docs/current/reference/htmlsingle/#boot-features-error-handling

	@Autowired
	private AriadnePlusPublisherHelper ariadneplusPublisherHelper;

	@RequestMapping(value = "/publish", method = RequestMethod.POST)
	public void publish(@RequestParam final String record, @RequestParam(required = false) String ariadneplusTarget) throws AriadnePlusPublisherException {
		getAriadnePlusPublisherHelper().publish(record, getTarget(ariadneplusTarget));
	}


	@RequestMapping(value = "/unpublish", method = RequestMethod.GET)
	public void unpublish(@RequestParam final String datasourceApi, @RequestParam(required = false) String ariadneplusTarget) throws AriadnePlusPublisherException {
		getAriadnePlusPublisherHelper().unpublish(datasourceApi, getTarget(ariadneplusTarget));
	}

	@RequestMapping(value = "/dropRegistry", method = RequestMethod.GET)
	public void unpublish() throws AriadnePlusPublisherException {
		getAriadnePlusPublisherHelper().dropRegistry();
	}

	private AriadnePlusTargets getTarget(String value) {
		return AriadnePlusTargets.valueOf(value);
	}

	public AriadnePlusPublisherHelper getAriadnePlusPublisherHelper() {
		return ariadneplusPublisherHelper;
	}

	public void setAriadnePlusPublisherHelper(final AriadnePlusPublisherHelper ariadneplusPublisherHelper) {
		this.ariadneplusPublisherHelper = ariadneplusPublisherHelper;
	}
}