/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import eu.dnetlib.ariadneplus.workflows.nodes.VirtuosoAriadnePlusException;
import eu.dnetlib.data.collector.ThreadSafeIterator;
import eu.dnetlib.rmi.data.CollectorServiceRuntimeException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class VirtuosoAriadnePlusIterator
extends ThreadSafeIterator {
    private static final Log log = LogFactory.getLog(VirtuosoAriadnePlusIterator.class);
    protected static final String ANY_TIME_QUERY_MS = "1800000";
    protected static final int QUEUE_TIMEOUT_SECONDS = 600;
    public static final String TERMINATOR = "ARNOLD";
    public static final String ERROR_TERMINATOR = "SCHWARZ";
    protected static final int SLEEP_MS = 5000;
    protected static final int MAX_RETRIES = 3;
    protected static final int LIMIT = 100;
    private String datasourceName;
    private String datasourceInterface;
    private String virtuosoReaderAPIUrl;
    private boolean started = false;
    private Map<String, Integer> errors = Maps.newHashMap();
    private List<String> listForClass = Lists.newArrayList();
    private BlockingQueue<String> elements = Queues.newArrayBlockingQueue((int)10);
    private String currentElement = null;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private RestTemplate restTemplate;

    private synchronized void verifyStarted() {
        if (!this.started) {
            this.started = true;
            this.fillQueue();
            this.getNextElement(3);
        }
    }

    protected void fillQueue() {
        log.info((Object)("Virtuoso reader at : " + this.getVirtuosoReaderAPIUrl()));
        this.getExecutor().submit(() -> {
            try {
                boolean again;
                int offset = 0;
                do {
                    List<String> subjectList = this.getSubjectList(offset);
                    for (String subject : subjectList) {
                        String xmlFile = this.tryGetRDF(subject, 3);
                        if (StringUtils.isBlank((CharSequence)xmlFile)) {
                            log.warn((Object)("Skipping blank RDF for " + subject));
                            continue;
                        }
                        this.getElements().offer(xmlFile, 600L, TimeUnit.SECONDS);
                    }
                    again = subjectList.size() == 100;
                    offset += 100;
                } while (again);
                log.debug((Object)"End of subject list, adding terminator to the queue");
                this.getElements().offer(TERMINATOR, 600L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                try {
                    this.getElements().offer(ERROR_TERMINATOR, 600L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e1) {
                    log.error((Object)e1.getMessage());
                }
            }
        });
        this.getExecutor().shutdown();
    }

    protected String tryGetRDF(String subjectURL, int attempt) throws URISyntaxException, InterruptedException, VirtuosoAriadnePlusException {
        if (!subjectURL.startsWith("http")) {
            log.debug((Object)("Skipping as non-http url: " + subjectURL));
            this.errors.merge("Non-http URLs", 1, Integer::sum);
            return null;
        }
        log.debug((Object)("Querying Api, remaining attempts: " + attempt));
        if (attempt <= 0) {
            this.errors.merge("Failed tryGetRDF", 1, Integer::sum);
            return null;
        }
        ResponseEntity<String> response = null;
        try {
            response = this.getRDF(subjectURL);
        }
        catch (ResourceAccessException e) {
            log.warn((Object)("Request timeout for " + subjectURL + ": I'll sleep and then try again"));
            Thread.sleep(5000L);
            return this.tryGetRDF(subjectURL, --attempt);
        }
        HttpStatus responseStatus = response.getStatusCode();
        if (responseStatus.is2xxSuccessful()) {
            String rdfFile = (String)response.getBody();
            if (StringUtils.isBlank((CharSequence)rdfFile)) {
                log.warn((Object)("Got blank RDF for " + subjectURL + " , let's try again..."));
                Thread.sleep(5000L);
                return this.tryGetRDF(subjectURL, --attempt);
            }
            String xmlFile = this.completeXML(rdfFile, subjectURL);
            return xmlFile;
        }
        if (responseStatus.is5xxServerError()) {
            log.warn((Object)("HTTP ERROR: " + responseStatus.value() + ": " + responseStatus.getReasonPhrase() + ": I'll sleep and then try again"));
            Thread.sleep(5000L);
            return this.tryGetRDF(subjectURL, --attempt);
        }
        log.error((Object)("ERROR: Can't get the RDF for " + subjectURL + " " + responseStatus.value() + ": " + responseStatus.getReasonPhrase()));
        this.errors.merge(responseStatus.value() + ": " + responseStatus.getReasonPhrase(), 1, Integer::sum);
        return null;
    }

    protected URI getURIForSubjectList(int offset) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(this.getVirtuosoReaderAPIUrl() + "/apiSubjects");
        builder.addParameter("api", this.getDatasourceInterface());
        builder.addParameter("limit", Integer.toString(100));
        builder.addParameter("offset", Integer.toString(offset));
        return builder.build();
    }

    protected List<String> getSubjectList(int offset) throws URISyntaxException, VirtuosoAriadnePlusException {
        List subjectList;
        URI uri = this.getURIForSubjectList(offset);
        log.debug((Object)("fillQueue -- Calling for subject list: " + uri.toString()));
        try {
            subjectList = (List)this.getRestTemplate().getForObject(uri, this.getListForClass().getClass());
        }
        catch (RestClientException rce) {
            throw new VirtuosoAriadnePlusException(rce);
        }
        return subjectList;
    }

    protected URI getURIForRDFRequest(String subjectURL) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(this.getVirtuosoReaderAPIUrl() + "/subject").addParameter("subjectURL", subjectURL).addParameter("timeout", ANY_TIME_QUERY_MS);
        return builder.build();
    }

    protected ResponseEntity<String> getRDF(String subjectURL) throws URISyntaxException {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.APPLICATION_XML}));
        URI uri = this.getURIForRDFRequest(subjectURL);
        log.debug((Object)("fillQueue -- Calling for subject RDF: " + uri.toString()));
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        return this.restTemplate.exchange(uri, HttpMethod.GET, entity, String.class);
    }

    public String completeXML(String rdfFile, String url) {
        String xmlEscapedURL = StringEscapeUtils.escapeXml11((String)url);
        String rdfFileNoXmlDecl = rdfFile.replaceAll("\\<\\?xml(.+?)\\?\\>", "").trim();
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><record xmlns=\"http://www.openarchives.org/OAI/2.0/\"><header xmlns:dri=\"http://www.driver-repository.eu/namespace/dri\"><dri:objIdentifier>" + xmlEscapedURL + "</dri:objIdentifier><dri:datasourceapi>" + this.datasourceInterface + "</dri:datasourceapi><dri:datasourcename>" + this.datasourceName + "</dri:datasourcename></header><metadata>" + rdfFileNoXmlDecl + "</metadata></record>";
    }

    public boolean doHasNext() {
        try {
            this.verifyStarted();
        }
        catch (Exception e) {
            this.getExecutor().shutdownNow();
            throw new CollectorServiceRuntimeException((Throwable)e);
        }
        switch (this.currentElement) {
            case "ARNOLD": {
                if (!this.executor.isTerminated()) {
                    this.executor.shutdownNow();
                }
                return false;
            }
            case "SCHWARZ": {
                this.executor.shutdownNow();
                throw new CollectorServiceRuntimeException("Error getting elements from virtuoso");
            }
        }
        return true;
    }

    public String doNext() {
        if (!this.hasNext()) {
            log.error((Object)"Next called but hasNext is false", (Throwable)new NoSuchElementException());
            throw new NoSuchElementException();
        }
        switch (this.currentElement) {
            case "ARNOLD": 
            case "SCHWARZ": {
                this.executor.shutdownNow();
                throw new NoSuchElementException();
            }
        }
        String res = this.currentElement;
        this.getNextElement(3);
        return res;
    }

    private void getNextElement(int attempt) {
        log.debug((Object)("polling from queue, remaining attempts: " + attempt));
        if (attempt <= 0) {
            this.currentElement = ERROR_TERMINATOR;
        } else {
            try {
                this.currentElement = this.elements.take();
            }
            catch (InterruptedException e) {
                this.currentElement = ERROR_TERMINATOR;
                this.executor.shutdownNow();
            }
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public VirtuosoAriadnePlusIterator datasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
        return this;
    }

    public VirtuosoAriadnePlusIterator virtuosoReaderAPIUrl(String virtuosoReaderAPIUrl) {
        this.virtuosoReaderAPIUrl = virtuosoReaderAPIUrl;
        return this;
    }

    public VirtuosoAriadnePlusIterator datasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
        return this;
    }

    public VirtuosoAriadnePlusIterator errors(Map<String, Integer> errors) {
        this.errors = errors;
        return this;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public String getVirtuosoReaderAPIUrl() {
        return this.virtuosoReaderAPIUrl;
    }

    public Map<String, Integer> getErrors() {
        return this.errors;
    }

    public BlockingQueue<String> getElements() {
        return this.elements;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public VirtuosoAriadnePlusIterator restTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        return this;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public boolean isStarted() {
        return this.started;
    }

    public List<String> getListForClass() {
        return this.listForClass;
    }

    public String getCurrentElement() {
        return this.currentElement;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public void setVirtuosoReaderAPIUrl(String virtuosoReaderAPIUrl) {
        this.virtuosoReaderAPIUrl = virtuosoReaderAPIUrl;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public void setErrors(Map<String, Integer> errors) {
        this.errors = errors;
    }

    public void setListForClass(List<String> listForClass) {
        this.listForClass = listForClass;
    }

    public void setElements(BlockingQueue<String> elements) {
        this.elements = elements;
    }

    public void setCurrentElement(String currentElement) {
        this.currentElement = currentElement;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

